close all
clear all
clc

theta=45
EpsX=0.008571428571429

name0=['D45_W40_Hh2_L140_G004_001_T'];

name1=[name0,'disp1_dx.rpt'];
name2=[name0,'disp1_sx.rpt'];
name3=[name0,'disp3_dx.rpt'];
name4=[name0,'disp3_sx.rpt'];        

[X,delta1_dx] = importfile1(name1,2);
[X,delta1_sx] = importfile1(name2,2);
[X,delta3_dx] = importfile1(name3,2);
[X,delta3_sx] = importfile1(name4,2);        

length=((delta1_dx-delta1_sx).^2+(delta3_dx-delta3_sx).^2).^(1/2);

alpha=atand((delta3_dx-delta3_sx)./(delta1_dx-delta1_sx));
betha=theta-alpha;     

delta_n=[sind(betha).* length];
delta_t=[cosd(betha).* length];

delta_n(delta_n<0)=0;

figure(61)
plot(0.5*delta_n/EpsX,(X-1)/2,'bo-','MarkerFaceColor','b')
DeltaNmean=trapz(X,0.5*delta_n/EpsX)
hold on
plot(0.5*delta_t/EpsX,(X-1)/2,'bo-')
DeltaTmean=trapz(X,0.5*delta_t/EpsX)
legend({'$\delta_n$','$\delta_t$'},'location','southeast','interpreter','latex', 'FontSize', 14)
xlabel('$\delta/(2h\varepsilon_x)$','interpreter','latex', 'FontSize', 14)
ylabel('$z/(2h)$','interpreter','latex', 'FontSize', 14)
yticks(-0.5:0.1:0)
xlim([0,2.25])


print('-f61','FigDeltaCrack','-dpng')
print('-f61','FigDeltaCrack','-depsc')
