import numpy as np
import matplotlib.pyplot as plt
import pickle


with open('JKUD45.pickle', 'rb') as f:
    i0,i1,Y,Psi4G,Psi5G,Psi6G,Psi7G,PsiGmean=pickle.load(f)

with open('JKUD45C1.pickle', 'rb') as f:
    i0A,i1A,YA,Psi4GA,Psi5GA,Psi6GA,Psi7GA,PsiGmeanA=pickle.load(f)
with open('JKUD45C2.pickle', 'rb') as f:
    i0A2,i1A2,YA2,Psi4GA2,Psi5GA2,Psi6GA2,Psi7GA2,PsiGmeanA2=pickle.load(f)

with open('JKUD60c.pickle', 'rb') as f:
    i0B,i1B,YB,Psi4GB,Psi5GB,Psi6GB,Psi7GB,PsiGmeanB=pickle.load(f)
with open('JKUD60CarbonFRP1.pickle', 'rb') as f:
    i0B1,i1B1,YB1,Psi3GB1,Psi4GB1,Psi5GB1,Psi6GB1,Psi7GB1,PsiGmeanB1=pickle.load(f)
with open('JKUD60carbon2c.pickle', 'rb') as f:
    i0B2,i1B2,YB2,Psi4GB2,Psi5GB2,Psi6GB2,Psi7GB2,PsiGmeanB2=pickle.load(f)

with open('JKUD75.pickle', 'rb') as f:
    i0C,i1C,i2C,i3C,YC,Psi4GC,Psi5GC,Psi6GC,Psi7GC,PsiGmeanC=pickle.load(f)
with open('JKUD75C1.pickle', 'rb') as f:
    i0C1,i1C1,i2C1,i3C1,YC1,Psi4GC1,Psi5GC1,Psi6GC1,Psi7GC1,PsiGmeanC1=pickle.load(f)
with open('JKUD75C2.pickle', 'rb') as f:
    i0C2,i1C2,i2C2,i3C2,YC2,Psi4GC2,Psi5GC2,Psi6GC2,Psi7GC2,PsiGmeanC2=pickle.load(f)



#%%
StrPsimeanB='GlassFRP1'
StrPsimeanB1='CarbonFRP1'
StrPsimeanB2='CarbonFRP2'
#StrPsimeanB=r'GlassFRP1:  $\bar{\psi}_{75\degree}= %.1f \degree$;$\bar{\psi}_{60\degree}= %.1f \degree$; $\bar{\psi}_{45\degree}= %.1f \degree$' %(PsiGmeanC,-PsiGmeanB,-PsiGmean)
#StrPsimeanB1=r'CarbonFRP1:$\bar{\psi}_{75\degree}= %.1f \degree$;$\bar{\psi}_{60\degree}= %.1f \degree$; $\bar{\psi}_{45\degree}= %.1f \degree$' %(PsiGmeanC1,-PsiGmeanB1,-PsiGmeanA)
#StrPsimeanB2=r'CarbonFRP2:$\bar{\psi}_{75\degree}= %.1f \degree$;$\bar{\psi}_{60\degree}= %.1f \degree$; $\bar{\psi}_{45\degree}= %.1f \degree$' %(PsiGmeanC2,-PsiGmeanB2,-PsiGmeanA2)


plt.figure(figsize=(7,5))


#%%

##plt.plot(Psi3GA[:i0],(YA[:i0]-1.0)/2.0,'-k')
#plt.plot(Psi4GA[:i0],(YA[:i0]-1.0)/2.0,'-k')
#plt.plot(Psi5GA[:i0],(YA[:i0]-1.0)/2.0,'-k')
#plt.plot(Psi6GA[:i0],(YA[:i0]-1.0)/2.0,'-k')
#plt.plot(Psi7GA[:i0],(YA[:i0]-1.0)/2.0,'-k')
#
##plt.plot(Psi3GA[i0A:i1A],(YA[i0A:i1A]-1.0)/2.0,'-k')
#plt.plot(Psi4GA[i0A:i1A],(YA[i0A:i1A]-1.0)/2.0,'-k')
#plt.plot(Psi5GA[i0A:i1A],(YA[i0A:i1A]-1.0)/2.0,'-k')
#plt.plot(Psi6GA[i0A:i1A],(YA[i0A:i1A]-1.0)/2.0,'-k')
#plt.plot(Psi7GA[i0A:i1A],(YA[i0A:i1A]-1.0)/2.0,'-k')
#
##plt.plot(Psi3GA[i1A:],(YA[i1A:]-1.0)/2.0,'.k', markersize=0.5)
#plt.plot(Psi4GA[i1A:],(YA[i1A:]-1.0)/2.0,'.k', markersize=0.5)
#plt.plot(Psi5GA[i1A:],(YA[i1A:]-1.0)/2.0,'.k', markersize=0.5)
#plt.plot(Psi6GA[i1A:],(YA[i1A:]-1.0)/2.0,'.k', markersize=0.5)
#plt.plot(Psi7GA[i1A:],(YA[i1A:]-1.0)/2.0,'.k', markersize=0.5)


#%%

plt.plot(-Psi4GB2,(YB2-1.0)/2.0,'-r',label=StrPsimeanB2)
plt.plot(-Psi5GB2,(YB2-1.0)/2.0,'-r')
plt.plot(-Psi6GB2,(YB2-1.0)/2.0,'-r')
plt.plot(-Psi7GB2,(YB2-1.0)/2.0,'-r')

#%%

plt.plot(-Psi4GB1,(YB1-1.0)/2.0,'-k',label=StrPsimeanB1)
plt.plot(-Psi5GB1,(YB1-1.0)/2.0,'-k')
plt.plot(-Psi6GB1,(YB1-1.0)/2.0,'-k')
plt.plot(-Psi7GB1,(YB1-1.0)/2.0,'-k')


#%%

plt.plot(-Psi4GB,(YB-1.0)/2.0,'-b',label=StrPsimeanB)
plt.plot(-Psi5GB,(YB-1.0)/2.0,'-b')
plt.plot(-Psi6GB,(YB-1.0)/2.0,'-b')
plt.plot(-Psi7GB,(YB-1.0)/2.0,'-b')

plt.plot(-Psi4G,(Y-1.0)/2.0,'-b')
plt.plot(-Psi5G,(Y-1.0)/2.0,'-b')
plt.plot(-Psi6G,(Y-1.0)/2.0,'-b')
plt.plot(-Psi7G,(Y-1.0)/2.0,'-b')

plt.plot(-Psi4GA,(YA-1.0)/2.0,'-k')
plt.plot(-Psi5GA,(YA-1.0)/2.0,'-k')
plt.plot(-Psi6GA,(YA-1.0)/2.0,'-k')
plt.plot(-Psi7GA,(YA-1.0)/2.0,'-k')

plt.plot(-Psi4GA2,(YA2-1.0)/2.0,'-r')
plt.plot(-Psi5GA2,(YA2-1.0)/2.0,'-r')
plt.plot(-Psi6GA2,(YA2-1.0)/2.0,'-r')
plt.plot(-Psi7GA2,(YA2-1.0)/2.0,'-r')

#

YC=(YC-1.0)/2.0;

plt.plot(Psi4GC[:i0C],YC[:i0C],'-b')
plt.plot(Psi5GC[:i0C],YC[:i0C],'-b')
plt.plot(Psi6GC[:i0C],YC[:i0C],'-b')
plt.plot(Psi7GC[:i0C],YC[:i0C],'-b')

plt.plot(Psi4GC[i0C:i1C],YC[i0C:i1C],'-b')
plt.plot(Psi5GC[i0C:i1C],YC[i0C:i1C],'-b')
plt.plot(Psi6GC[i0C:i1C],YC[i0C:i1C],'-b')
plt.plot(Psi7GC[i0C:i1C],YC[i0C:i1C],'-b')

plt.plot(Psi4GC[i1C:i2C],YC[i1C:i2C],'.b', markersize=0.5)
plt.plot(Psi5GC[i1C:i2C],YC[i1C:i2C],'.b', markersize=0.5)
plt.plot(Psi6GC[i1C:i2C],YC[i1C:i2C],'.b', markersize=0.5)
plt.plot(Psi7GC[i1C:i2C],YC[i1C:i2C],'.b', markersize=0.5)

plt.plot(Psi4GC[i2C:i3C],YC[i2C:i3C],'-b')
plt.plot(Psi5GC[i2C:i3C],YC[i2C:i3C],'-b')
plt.plot(Psi6GC[i2C:i3C],YC[i2C:i3C],'-b')
plt.plot(Psi7GC[i2C:i3C],YC[i2C:i3C],'-b')

plt.plot(Psi4GC[i3C:],YC[i3C:],'.b', markersize=0.5)
plt.plot(Psi5GC[i3C:],YC[i3C:],'.b', markersize=0.5)
plt.plot(Psi6GC[i3C:],YC[i3C:],'.b', markersize=0.5)
plt.plot(Psi7GC[i3C:],YC[i3C:],'.b', markersize=0.5)

YC1=(YC1-1.0)/2.0;

plt.plot(Psi4GC1[:i0C1],YC1[:i0C1],'-k')
plt.plot(Psi5GC1[:i0C1],YC1[:i0C1],'-k')
plt.plot(Psi6GC1[:i0C1],YC1[:i0C1],'-k')
plt.plot(Psi7GC1[:i0C1],YC1[:i0C1],'-k')

plt.plot(Psi4GC1[i0C1:i1C1],YC1[i0C1:i1C1],'-k')
plt.plot(Psi5GC1[i0C1:i1C1],YC1[i0C1:i1C1],'-k')
plt.plot(Psi6GC1[i0C1:i1C1],YC1[i0C1:i1C1],'-k')
plt.plot(Psi7GC1[i0C1:i1C1],YC1[i0C1:i1C1],'-k')

plt.plot(Psi4GC1[i1C1:i2C1],YC1[i1C1:i2C1],'.k', markersize=0.5)
plt.plot(Psi5GC1[i1C1:i2C1],YC1[i1C1:i2C1],'.k', markersize=0.5)
plt.plot(Psi6GC1[i1C1:i2C1],YC1[i1C1:i2C1],'.k', markersize=0.5)
plt.plot(Psi7GC1[i1C1:i2C1],YC1[i1C1:i2C1],'.k', markersize=0.5)

plt.plot(Psi4GC1[i2C1:i3C1],YC1[i2C1:i3C1],'-k')
plt.plot(Psi5GC1[i2C1:i3C1],YC1[i2C1:i3C1],'-k')
plt.plot(Psi6GC1[i2C1:i3C1],YC1[i2C1:i3C1],'-k')
plt.plot(Psi7GC1[i2C1:i3C1],YC1[i2C1:i3C1],'-k')

plt.plot(Psi4GC1[i3C1:],YC1[i3C1:],'.k', markersize=0.5)
plt.plot(Psi5GC1[i3C1:],YC1[i3C1:],'.k', markersize=0.5)
plt.plot(Psi6GC1[i3C1:],YC1[i3C1:],'.k', markersize=0.5)
plt.plot(Psi7GC1[i3C1:],YC1[i3C1:],'.k', markersize=0.5)

YC2=(YC2-1.0)/2.0;

plt.plot(Psi4GC2[:i0C2],YC2[:i0C2],'-r')
plt.plot(Psi5GC2[:i0C2],YC2[:i0C2],'-r')
plt.plot(Psi6GC2[:i0C2],YC2[:i0C2],'-r')
plt.plot(Psi7GC2[:i0C2],YC2[:i0C2],'-r')

plt.plot(Psi4GC2[i0C2:i1C2],YC2[i0C2:i1C2],'-r')
plt.plot(Psi5GC2[i0C2:i1C2],YC2[i0C2:i1C2],'-r')
plt.plot(Psi6GC2[i0C2:i1C2],YC2[i0C2:i1C2],'-r')
plt.plot(Psi7GC2[i0C2:i1C2],YC2[i0C2:i1C2],'-r')

plt.plot(Psi4GC2[i1C2:i2C2],YC2[i1C2:i2C2],'.r', markersize=0.5)
plt.plot(Psi5GC2[i1C2:i2C2],YC2[i1C2:i2C2],'.r', markersize=0.5)
plt.plot(Psi6GC2[i1C2:i2C2],YC2[i1C2:i2C2],'.r', markersize=0.5)
plt.plot(Psi7GC2[i1C2:i2C2],YC2[i1C2:i2C2],'.r', markersize=0.5)

plt.plot(Psi4GC2[i2C2:i3C2],YC2[i2C2:i3C2],'-r')
plt.plot(Psi5GC2[i2C2:i3C2],YC2[i2C2:i3C2],'-r')
plt.plot(Psi6GC2[i2C2:i3C2],YC2[i2C2:i3C2],'-r')
plt.plot(Psi7GC2[i2C2:i3C2],YC2[i2C2:i3C2],'-r')

plt.plot(Psi4GC2[i3C2:],YC2[i3C2:],'.r', markersize=0.5)
plt.plot(Psi5GC2[i3C2:],YC2[i3C2:],'.r', markersize=0.5)
plt.plot(Psi6GC2[i3C2:],YC2[i3C2:],'.r', markersize=0.5)
plt.plot(Psi7GC2[i3C2:],YC2[i3C2:],'.r', markersize=0.5)

#%%
#Text on graph
Psi75G1=r'$\bar{\psi}= %.1f\degree$' %(PsiGmeanC)
Psi60G1=r'$\bar{\psi}= %.1f\degree$' %(-PsiGmeanB)
Psi45G1=r'$\bar{\psi}= %.1f\degree$' %(-PsiGmean)
Psi75C1=r'$\bar{\psi}= %.1f\degree$' %(PsiGmeanC1)
Psi60C1=r'$\bar{\psi}= %.1f\degree$' %(-PsiGmeanB1)
Psi45C1=r'$\bar{\psi}= %.1f\degree$' %(-PsiGmeanA)
Psi75C2=r'$\bar{\psi}= %.1f\degree$' %(PsiGmeanC2)
Psi60C2=r'$\bar{\psi}= %.1f\degree$' %(-PsiGmeanB2)
Psi45C2=r'$\bar{\psi}= %.1f\degree$' %(-PsiGmeanA2)

plt.text(5,-0.44,Psi75G1,fontsize=12)
plt.arrow(15,-0.45,4,-0.02,color='blue')
plt.text(5,-0.39,Psi75C1,fontsize=12)
plt.arrow(15,-0.40,14,-0.02)
plt.text(5,-0.34,Psi75C2,fontsize=12)
plt.arrow(15,-0.35,26,-0.04,color='red')

plt.text(30,-0.09,r'$\theta=75\degree$',fontsize=12)
plt.arrow(35,-0.1,-14,-0.10,color='blue')
plt.arrow(35,-0.1,-4,-0.10)
plt.arrow(35,-0.1,6,-0.10,color='red')

plt.text(45,-0.09,r'$\theta=60\degree$',fontsize=12)
plt.arrow(52,-0.1,-8,-0.10,color='blue')
plt.arrow(52,-0.1,6,-0.10)
plt.arrow(52,-0.1,17,-0.10,color='red')

plt.text(45,-0.44,Psi60G1,fontsize=12)
plt.arrow(50,-0.45,-6,-0.02,color='blue')
plt.text(45,-0.39,Psi60C1,fontsize=12)
plt.arrow(50,-0.40,9,-0.02)
plt.text(45,-0.34,Psi60C2,fontsize=12)
plt.arrow(50,-0.35,20,-0.04,color='red')

plt.text(72,-0.09,r'$\theta=45\degree$',fontsize=12)
plt.arrow(78,-0.1,-10,-0.07,color='blue')
plt.arrow(78,-0.1,6,-0.10)
plt.arrow(78,-0.1,10,-0.10,color='red')

plt.text(72,-0.44,Psi45G1,fontsize=12)
plt.arrow(78,-0.45,-10,-0.02,color='blue')
plt.text(72,-0.39,Psi45C1,fontsize=12)
plt.arrow(78,-0.40,8,-0.02)
plt.text(72,-0.34,Psi45C2,fontsize=12)
plt.arrow(78,-0.35,11,-0.02,color='red')



plt.ylim(-0.5,0)
plt.xlim(0,90)
plt.ylabel('z/(2h)',fontsize=18)
plt.xlabel(r'$\psi [\degree]$',fontsize=18)
plt.grid()
plt.legend(loc=2,fontsize=12)
plt.savefig('FIG11-PsiFig.png')
plt.savefig('FIG11-PsiFig.eps')
plt.show()


