# -*- coding: mbcs -*-
#
# Abaqus/Viewer Release 6.13-3 replay file
# Internal Version: 2013_10_09-13.28.52 126623
# Run by s131596 on Wed May 14 00:09:11 2014
#
## Postprocessing
	# Default ABAQUS inputs
from part import *
from material import *
from section import *
from assembly import *
from step import *
from interaction import *
from load import *
from mesh import *
from optimization import *
from job import *
from sketch import *
from visualization import *
from connectorBehavior import *

# 15 +b, b=balance

JobName='CarbonFRP1-Umodel-D35'

S11 =       JobName+'S11.rpt'
S12 =       JobName+'S12.rpt'
S22 =       JobName+'S22.rpt'
e11 =       JobName+'e11.rpt'
e12 =       JobName+'e12.rpt'
e22 =       JobName+'e22.rpt'
d1dx = JobName+'disp1_dx.rpt'
d1sx = JobName+'disp1_sx.rpt'
d3dx = JobName+'disp3_dx.rpt'
d3sx = JobName+'disp3_sx.rpt'


## Post-processing
session.viewports['Viewport: 1'].setValues(displayedObject=mdb.models['Model-1'].rootAssembly)
session.viewports['Viewport: 1'].setValues(displayedObject=session.openOdb(name=JobName+'.odb'))
session.viewports['Viewport: 1'].assemblyDisplay.setValues(
    optimizationTasks=OFF, geometricRestrictions=OFF, stopConditions=OFF) 
session.viewports['Viewport: 1'].setValues(displayedObject=session.odbs[JobName+'.odb'])


session.Path(name='dx', type=POINT_LIST, expression=((0.0+0.0001, 3.0, 110.0), (
    0.0+0.0001, 4.0, 110.0)))
session.Path(name='sx', type=POINT_LIST, expression=((0.0-0.0001, 3.0, 110.0), (
    0.0-0.0001, 4.0, 110.0)))
session.Path(name='global', type=POINT_LIST, expression=((0.0-0.0001, 4.0, 110.0), ( -90.0, 4.0, 110.0)))

session.viewports['Viewport: 1'].odbDisplay.setPrimaryVariable(
    variableLabel='S', outputPosition=INTEGRATION_POINT, refinement=(COMPONENT, 
    'S11'))
pth = session.paths['global']
session.XYDataFromPath(name='s11', path=pth, includeIntersections=True, 
    pathStyle=PATH_POINTS, numIntervals=10, shape=UNDEFORMED, 
    labelType=TRUE_DISTANCE)
x0 = session.xyDataObjects['s11']





session.viewports['Viewport: 1'].odbDisplay.setPrimaryVariable(
    variableLabel='S', outputPosition=INTEGRATION_POINT, refinement=(COMPONENT, 
    'S12'))
pth = session.paths['global']
session.XYDataFromPath(name='s12', path=pth, includeIntersections=True, 
    pathStyle=PATH_POINTS, numIntervals=10, shape=UNDEFORMED, 
    labelType=TRUE_DISTANCE)
	
	
	
	

session.viewports['Viewport: 1'].odbDisplay.setPrimaryVariable(
    variableLabel='S', outputPosition=INTEGRATION_POINT, refinement=(COMPONENT, 
    'S22'))
pth = session.paths['global']
session.XYDataFromPath(name='s22', path=pth, includeIntersections=True, 
    pathStyle=PATH_POINTS, numIntervals=10, shape=UNDEFORMED, 
    labelType=TRUE_DISTANCE)
	
	#STRAINS
	
session.viewports['Viewport: 1'].odbDisplay.setPrimaryVariable(
    variableLabel='E', outputPosition=INTEGRATION_POINT, refinement=(COMPONENT, 
    'E11'))
pth = session.paths['global']
session.XYDataFromPath(name='e11', path=pth, includeIntersections=True, 
    pathStyle=PATH_POINTS, numIntervals=10, shape=UNDEFORMED, 
    labelType=TRUE_DISTANCE)






session.viewports['Viewport: 1'].odbDisplay.setPrimaryVariable(
    variableLabel='E', outputPosition=INTEGRATION_POINT, refinement=(COMPONENT, 
    'E12'))
pth = session.paths['global']
session.XYDataFromPath(name='e12', path=pth, includeIntersections=True, 
    pathStyle=PATH_POINTS, numIntervals=10, shape=UNDEFORMED, 
    labelType=TRUE_DISTANCE)
	
	
	
	

session.viewports['Viewport: 1'].odbDisplay.setPrimaryVariable(
    variableLabel='E', outputPosition=INTEGRATION_POINT, refinement=(COMPONENT, 
    'E22'))
pth = session.paths['global']
session.XYDataFromPath(name='e22', path=pth, includeIntersections=True, 
    pathStyle=PATH_POINTS, numIntervals=10, shape=UNDEFORMED, 
    labelType=TRUE_DISTANCE)

	#DISPLACEMENTS
	
	
	
	
	

session.viewports['Viewport: 1'].odbDisplay.setPrimaryVariable(
    variableLabel='U', outputPosition=NODAL, refinement=(COMPONENT, 'U1'))
pth = session.paths['dx']
session.XYDataFromPath(name='u1dx', path=pth, includeIntersections=True, 
    pathStyle=PATH_POINTS, numIntervals=10, shape=UNDEFORMED, 
    labelType=TRUE_DISTANCE_Y)
	
session.viewports['Viewport: 1'].odbDisplay.setPrimaryVariable(
    variableLabel='U', outputPosition=NODAL, refinement=(COMPONENT, 'U1'))
pth = session.paths['sx']
session.XYDataFromPath(name='u1sx', path=pth, includeIntersections=True, 
    pathStyle=PATH_POINTS, numIntervals=10, shape=UNDEFORMED, 
    labelType=TRUE_DISTANCE_Y)
	
session.viewports['Viewport: 1'].odbDisplay.setPrimaryVariable(
    variableLabel='U', outputPosition=NODAL, refinement=(COMPONENT, 'U3'))
pth = session.paths['dx']
session.XYDataFromPath(name='u3dx', path=pth, includeIntersections=True, 
    pathStyle=PATH_POINTS, numIntervals=10, shape=UNDEFORMED, 
    labelType=TRUE_DISTANCE_Y)
	
session.viewports['Viewport: 1'].odbDisplay.setPrimaryVariable(
    variableLabel='U', outputPosition=NODAL, refinement=(COMPONENT, 'U3'))
pth = session.paths['sx']
session.XYDataFromPath(name='u3sx', path=pth, includeIntersections=True, 
    pathStyle=PATH_POINTS, numIntervals=10, shape=UNDEFORMED, 
    labelType=TRUE_DISTANCE_Y)
	
	

x0 = session.xyDataObjects['e11']
session.writeXYReport(fileName=e11, xyData=(x0, ))
x0 = session.xyDataObjects['e12']
session.writeXYReport(fileName=e12, xyData=(x0, ))
x0 = session.xyDataObjects['e22']
session.writeXYReport(fileName=e22, xyData=(x0, ))
x0 = session.xyDataObjects['s11']
session.writeXYReport(fileName=S11, xyData=(x0, ))
x0 = session.xyDataObjects['s22']
session.writeXYReport(fileName=S22, xyData=(x0, ))
x0 = session.xyDataObjects['s12']
session.writeXYReport(fileName=S12, xyData=(x0, ))
x0 = session.xyDataObjects['u1dx']
session.writeXYReport(fileName=d1dx, xyData=(x0, ))
x0 = session.xyDataObjects['u1sx']
session.writeXYReport(fileName=d1sx, xyData=(x0, ))
x0 = session.xyDataObjects['u3dx']
session.writeXYReport(fileName=d3dx, xyData=(x0, ))
x0 = session.xyDataObjects['u3sx']
session.writeXYReport(fileName=d3sx, xyData=(x0, ))

#del session.xyDataObjects['e11']
#del session.xyDataObjects['e12']
#del session.xyDataObjects['e22']
#del session.xyDataObjects['s11']
#del session.xyDataObjects['s12']
#del session.xyDataObjects['s22']
#del session.xyDataObjects['u1dx']
#del session.xyDataObjects['u1sx']
#del session.xyDataObjects['u3dx']
#del session.xyDataObjects['u3sx']
#del session.paths['dx']
#del session.paths['global']
#del session.paths['sx']
   