import numpy as np
import matplotlib.pyplot as plt

factor=1.60304001445809

FileName='CrackTip-D45-ModelA-GlassFRP1'

Y = np.loadtxt(FileName+'-Y.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)-3.0
YJ=Y
J1 = np.loadtxt(FileName+'-J1.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J2 = np.loadtxt(FileName+'-J2.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J3 = np.loadtxt(FileName+'-J3.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J4 = np.loadtxt(FileName+'-J4.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J5 = np.loadtxt(FileName+'-J5.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J6 = np.loadtxt(FileName+'-J6.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J7 = np.loadtxt(FileName+'-J7.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J1[0]=0
J2[0]=0
J3[0]=0
J4[0]=0
J5[0]=0
J6[0]=0
J7[0]=0

J3mean=np.trapz(J3,x=Y)
J4mean=np.trapz(J4,x=Y)
J5mean=np.trapz(J5,x=Y)
J6mean=np.trapz(J6,x=Y)
J7mean=np.trapz(J7,x=Y)
Jmean=np.mean((J4mean,J5mean,J6mean,J7mean))

StrJmean=r'$J_{mean}^{4-7}$= %.4f' %(Jmean)

plt.figure(figsize=(7,5))
plt.plot(J1,Y,':b',label='Contour 1')
plt.plot(J2,Y,'-.b',label='Contour 2')
plt.plot(J3,Y,'-b',label='Contour 3-7')
plt.plot(J4,Y,'-b')
plt.plot(J5,Y,'-b')
plt.plot(J6,Y,'-b')
plt.plot(J7,Y,'-b')
plt.plot((Jmean,Jmean),(0,1),'--b',label=StrJmean)
plt.ylabel('z/h',fontsize=18)
plt.xlabel(r'$J(z)/(\varepsilon_x \sigma_x h)$',fontsize=18)
plt.legend(loc=2,fontsize=14)
plt.xlim(0,0.4)
plt.ylim(0,1)
#plt.ylim((0,2))
plt.grid()
plt.savefig(FileName+'-JFig.png')
plt.savefig(FileName+'-JFig.eps')
plt.show()

