import numpy as np
import matplotlib.pyplot as plt
import pickle

f1=1.60304001445809

E1=30600
E2=8620
G12=3250
nu12=0.2858
nu21=0.2858*(E2/E1)

rho=np.sqrt(E1*E2)/(2.0*G12)-np.sqrt(nu12*nu21)
lamb=E2/E1

Kfract=np.sqrt((1.0+rho)/(2*E1*E2))

FileName='CrackTip-D45-ModelA-GlassFRP1'
i0=30
i1=30

Y0 = np.loadtxt(FileName+'-Y.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)-3.0
KI1 = np.loadtxt(FileName+'-K11.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)
KI2 = np.loadtxt(FileName+'-K12.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)
KI3 = np.loadtxt(FileName+'-K13.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)
KI4 = np.loadtxt(FileName+'-K14.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)
KI5 = np.loadtxt(FileName+'-K15.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)
KI6 = np.loadtxt(FileName+'-K16.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)
KI7 = np.loadtxt(FileName+'-K17.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)

print(KI7)

KI1[0]=0
KI2[0]=0
KI3[0]=0
KI4[0]=0
KI5[0]=0
KI6[0]=0
KI7[0]=0

Y=np.delete(Y0,np.arange(i0,i1))
KI1=np.delete(KI1,np.arange(i0,i1))
KI2=np.delete(KI2,np.arange(i0,i1))
KI3=np.delete(KI3,np.arange(i0,i1))
KI4=np.delete(KI4,np.arange(i0,i1))
KI5=np.delete(KI5,np.arange(i0,i1))
KI6=np.delete(KI6,np.arange(i0,i1))
KI7=np.delete(KI7,np.arange(i0,i1))

GI1=Kfract*lamb**(-0.25)*np.power(KI1,2)/f1
GI2=Kfract*lamb**(-0.25)*np.power(KI2,2)/f1
GI3=Kfract*lamb**(-0.25)*np.power(KI3,2)/f1
GI4=Kfract*lamb**(-0.25)*np.power(KI4,2)/f1
GI5=Kfract*lamb**(-0.25)*np.power(KI5,2)/f1
GI6=Kfract*lamb**(-0.25)*np.power(KI6,2)/f1
GI7=Kfract*lamb**(-0.25)*np.power(KI7,2)/f1

GI3mean=np.trapz(GI3,x=Y)
GI4mean=np.trapz(GI4,x=Y)
GI5mean=np.trapz(GI5,x=Y)
GI6mean=np.trapz(GI6,x=Y)
GI7mean=np.trapz(GI7,x=Y)
GImean=np.mean((GI4mean,GI5mean,GI6mean,GI7mean))


KII1 = np.loadtxt(FileName+'-K21.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)
KII2 = np.loadtxt(FileName+'-K22.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)
KII3 = np.loadtxt(FileName+'-K23.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)
KII4 = np.loadtxt(FileName+'-K24.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)
KII5 = np.loadtxt(FileName+'-K25.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)
KII6 = np.loadtxt(FileName+'-K26.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)
KII7 = np.loadtxt(FileName+'-K27.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)
KII1[0]=0
KII2[0]=0
KII3[0]=0
KII4[0]=0
KII5[0]=0
KII6[0]=0
KII7[0]=0

KII1=np.delete(KII1,np.arange(i0,i1))
KII2=np.delete(KII2,np.arange(i0,i1))
KII3=np.delete(KII3,np.arange(i0,i1))
KII4=np.delete(KII4,np.arange(i0,i1))
KII5=np.delete(KII5,np.arange(i0,i1))
KII6=np.delete(KII6,np.arange(i0,i1))
KII7=np.delete(KII7,np.arange(i0,i1))

Psi1=np.degrees(np.arctan(KII1/KI1))
Psi2=np.degrees(np.arctan(KII2/KI2))
Psi3=np.degrees(np.arctan(KII3/KI3))
Psi4=np.degrees(np.arctan(KII4/KI4))
Psi5=np.degrees(np.arctan(KII5/KI5))
Psi6=np.degrees(np.arctan(KII6/KI6))
Psi7=np.degrees(np.arctan(KII7/KI7))

Psi4mean=np.trapz(Psi4[1:],x=Y[1:],)
Psi5mean=np.trapz(Psi5[1:],x=Y[1:],)
Psi6mean=np.trapz(Psi6[1:],x=Y[1:],)
Psi7mean=np.trapz(Psi7[1:],x=Y[1:],)
Psimean=np.mean((Psi4mean,Psi5mean,Psi6mean,Psi7mean))

GII1=Kfract*lamb**(0.25)*np.power(KII1,2)/f1
GII2=Kfract*lamb**(0.25)*np.power(KII2,2)/f1
GII3=Kfract*lamb**(0.25)*np.power(KII3,2)/f1
GII4=Kfract*lamb**(0.25)*np.power(KII4,2)/f1
GII5=Kfract*lamb**(0.25)*np.power(KII5,2)/f1
GII6=Kfract*lamb**(0.25)*np.power(KII6,2)/f1
GII7=Kfract*lamb**(0.25)*np.power(KII7,2)/f1

GII3mean=np.trapz(GII3,x=Y)
GII4mean=np.trapz(GII4,x=Y)
GII5mean=np.trapz(GII5,x=Y)
GII6mean=np.trapz(GII6,x=Y)
GII7mean=np.trapz(GII7,x=Y)
GIImean=np.mean((GII4mean,GII5mean,GII6mean,GII7mean))

Gs1=GI1+GII1
Gs2=GI2+GII2
Gs3=GI3+GII3
Gs4=GI4+GII4
Gs5=GI5+GII5
Gs6=GI6+GII6
Gs7=GI7+GII7
Gsmean=GImean+GIImean

plt.figure(figsize=(7,5))
#plt.plot(GI1,Y,':b')
#plt.plot(GI2,Y,'-.b')
plt.plot(GI3,Y,'-b',label=r'$G_I$')
plt.plot(GI4,Y,'-b')
plt.plot(GI5,Y,'-b')
plt.plot(GI6,Y,'-b')
plt.plot(GI7,Y,'-b')
#plt.plot(GII1,Y,':r')
#plt.plot(GII2,Y,'-.r')
plt.plot(GII3,Y,'-r',label=r'$G_{II}$')
plt.plot(GII4,Y,'-r')
plt.plot(GII5,Y,'-r')
plt.plot(GII6,Y,'-r')
plt.plot(GII7,Y,'-r')
#plt.plot(Gs1,Y,':k',label='Gs: Contour 1')
#plt.plot(Gs2,Y,'-.k')
plt.plot(Gs3,Y,'-k',label=r'$G_{ss}$')
plt.plot(Gs4,Y,'-k')
plt.plot(Gs5,Y,'-k')
plt.plot(Gs6,Y,'-k')
plt.plot(Gs7,Y,'-k')
plt.plot((GImean,GImean),(0,1),'--b',label='mean')
plt.plot((GIImean,GIImean),(0,1),'--r')
plt.plot((Gsmean,Gsmean),(0,1),'--k')
plt.ylabel('z/h',fontsize=18)
plt.xlabel(r'$G(z)/(\varepsilon_x \sigma_x h)$',fontsize=18)
plt.legend(loc=4,fontsize=14)
#plt.xlim(0,0.4)
plt.ylim(0,1)
#plt.ylim((0,2))
plt.grid()
plt.savefig(FileName+'-GFig.png')
plt.savefig(FileName+'-GFig.eps')
plt.show()

plt.figure(figsize=(7,5))
plt.plot(-Psi4,Y,'-k',label=r'$\psi$ for Contours 4-7')
plt.plot(-Psi5,Y,'-k')
plt.plot(-Psi6,Y,'-k')
plt.plot(-Psi7,Y,'-k')
plt.xlim(0,90)
plt.ylabel('z/h',fontsize=18)
plt.xlabel(r'$\psi$',fontsize=18)
plt.grid()
plt.savefig(FileName+'-PsiFig.png')
plt.savefig(FileName+'-PsiFig.eps')
plt.legend(loc=2,fontsize=14)
plt.show()

with open('JKUD45.pickle', 'wb') as f:
    pickle.dump([i0,i1,Y,Psi4,Psi5,Psi6,Psi7,Psimean], f)
