close all
clear all
clc

% - - - - - - - - - - - - - - - - %
% -     Program Setup           - %
% - - - - - - - - - - - - - - - - %
layers=8;
% Theta=45;
 T_0=linspace(0,90,91+90*10);

%%T_1=[0 5 10 15 20 25 30 35 40 42 45 47 50 52 55 60 65 70 75 80 82 85 87 88 90]
% T_1=[10 20 45 45 45 45 47 50 52 55 60 65 70 75 80 82 85 87 88 90]
%%T_2=[5 10 15 20 25 30 35 40 45 47 50 52 55 60 65 70 75 80 85 90]
%%T_3=[5 10 15 20 25 30 35 40 42 45 47 48 50 52 55 60 65 70 75 80 85 90]
%%T_4=[5 10 15 20 25 30 35 40 42 45 47 48 50 52 55 60 65 70 75 80 85 90]
T_1=[0 5 10 15 20 25 30 35 40 42 45 47 48 50 52 55 57 59 60 62 65 70 75 80 85 90]
T_2=[0 5 10 15 20 25 30 35 40 42 45 47 48 50 52 55 57 59 60 62 65 70 75 80 85 90]
T_3=[0 5 10 15 20 25 30 35 40 42 45 47 48 50 52 55 57 59 60 62 65 70 75 80 85 90]
T_4=[0 5 10 15 20 25 30 35 40 42 45 47 48 50 52 55 57 59 60 62 65 70 75 80 85 90]
% - - - - - - - - - - - - - - - - %
% -    		 MATERIAL 	 		- %
% - - - - - - - - - - - - - - - - %

d_E1=[30620 41156.4 126046 265642]; %MPa
d_E2=[8620 10325.2 7556.61 5490.63]; %MPa
d_G12=[3250 3786.96 3694.98 3538.60]; %MPa
d_G13=d_G12;
d_G23=[2900 3653.62 2697.08 2372.76]; %MPa
d_nu12=[0.2858 0.258965 0.262260 0.266280];
d_nu23=[0.3261 0.413335 0.400424 0.401223];
d_nu13=d_nu12;
d_E3=d_E2;

figure(1)
plot([0,0],[0,0],'b--')
hold on
plot([0,0],[0,0],'g-')
plot([0,0],[0,0],'k--')
plot([0,0],[0,0],'r-')


for m=1:4
    if m==1
        T=T_1;
    elseif m==2
        T=T_2;
    elseif m==3
        T=T_3;
    else
        T=T_4;
    end
% T=T_0;
    Sigma_local=cell(1,length(T));
    Epsilon_local=cell(1,length(T));
    
    Sigma_global=cell(1,length(T));
    Epsilon_global=cell(1,length(T));
    SSig=zeros(1,length(T));
    for k=1:length(T)
        Theta=T(k);
        theta=[0,Theta,0,-Theta,-Theta,0,Theta,0 ]*pi/180;
        h=1;
        t = [h h h h h h h h];
        
        % - - - - - - - - - - - - - - - - %
        % -    		 MATERIAL 	 		- %
        % - - - - - - - - - - - - - - - - %
        
        E1=d_E1(m); %MPa
        E2=d_E2(m); %MPa
        G12=d_G12(m); %MPa
        G13=G12;
        G23=d_G23(m); %MPa
        nu12=d_nu12(m);
        nu23=d_nu23(m);
        nu13=nu12;
        E3=E2;
        
        
        
        
        % - - - - - - - - - - - - - - - - %
        % -  Z-Values for the laminate	- %
        % - - - - - - - - - - - - - - - - %
        z(1)=-sum(t)/2;
        for i=2:layers+1
            z(i)=z(i-1)+t(i-1);
        end
        
        % - - - - - - - - - - - - - - - - %
        % -  	Initializing			- %
        % - - - - - - - - - - - - - - - - %
        sigma_local= cell(1,layers*3);
        epsilon_local=cell(1,layers*3);
        for i=1:layers*3
            sigma_local{i}=zeros(3,1);
            epsilon_local{i}=zeros(3,1);
        end
        ABBD=zeros(6);
        A=zeros(3);
        B=zeros(3);
        D=zeros(3);
        % - - - - - - - - - - - - - - - - %
        % - Loop over layers  - %
        % - - - - - - - - - - - - - - - - %
        for i=1:layers
            
            [Q_global]=Qmatrix(theta(i),E1,E2,E3,nu12,nu23,nu13,G12,G13,G23);
            
            A = A + (Q_global*(z(i+1)-z(i)));
            
            B = B + (Q_global*1/2*(z(i+1)^2-z(i)^2));
            
            D = D + (Q_global*1/3*(z(i+1)^3-z(i)^3));
        end
        ABBD(1:3,1:3)=A;
        ABBD(4:6,1:3)=B;
        ABBD(1:3,4:6)=B;
        ABBD(4:6,4:6)=D;
        a1=find(T_1==45);
        a2=find(T_2==45);
        a3=find(T_3==45);
        a4=find(T_4==45);
        %         if m==1
        %             if k<=a(1)
        %                 L=40;
        %             elseif k==a(2)
        %                 L=60;
        %             elseif k==a(3)
        %                 L=80;
        %             else
        %                 L=140;
        %             end
        %         elseif m==3
        %             L=140;
        %         else
        %             L=140;
        %         end
        
        if m==3 & k<a3(1)
            L=180;
        elseif m==4 & k<a4(1)
            L=180
        else
            L=140;
        end
        
%          L=140;
        
        
        %         L=140;
        d=2*0.6;
        eps=zeros(3,1);
        eps(1)=d/L;
        eps(2)=-(A(1,2)*A(3,3)-A(1,3)*A(3,2))*eps(1)/(A(2,2)*A(3,3)-A(2,3)*A(3,2));
        eps(3)=-(A(1,2)*eps(1)+A(2,2)*eps(2))/A(3,2);
        eps(3)=0;
        F(1)=A(1,1)*eps(1)+A(2,1)*eps(2)+A(3,1)*eps(3);
        
        for i=1:layers
            [Q_global]=Qmatrix(theta(i),E1,E2,E3,nu12,nu23,nu13,G12,G13,G23);
            sig{i}=Q_global*eps;
            if i==4
                Q_global;
            end
        end
        h=2;
        factor=(h*eps(1)*sig{4}(1));
        Sig=sig{4};
        
        
        M=[0;0;0];
        NM=zeros(6,1);
        NM(4:6)=M;
        NM(1)=F;
        NM(4:6)=M;
        ebka_global=ABBD\NM;
        t_mod=zeros(1,size(t,2)*2);
        for i = 1:size(t,2)
            t_mod(2*i-1)=t(i)/2;
            t_mod(2*i)=t(i)/2;
        end
        zm(1)=-sum(t)/2;
        for i=2:2*layers+1
            zm(i)=zm(i-1)+t_mod(i-1);
        end
        c=cosd([0,theta,0,-theta]);
        s=sind([0,theta,0,-theta]);
        for i=1:layers
            for j=1:3
                if j==1
                    [sigma_local{3*i-2},epsilon_local{3*i-2},epsilon_global{3*i-2}]  =   sigmalocal(theta(i),E1,E2,E3,nu12,nu23,nu13,G12,G13,G23,ebka_global,zm(i*2-1));
                    Q_g=Qmatrix(theta(i),E1,E2,E3,nu12,nu23,nu13,G12,G13,G23);
                    sigma_global{3*i-2}=Q_g*epsilon_global{3*i-2};
                    z_plot(3*i-2)=zm(i*2-1);
                elseif j==2
                    [sigma_local{3*i-1},epsilon_local{3*i-1},epsilon_global{3*i-1}]  =   sigmalocal(theta(i),E1,E2,E3,nu12,nu23,nu13,G12,G13,G23,ebka_global,zm(i*2));
                    [Q_g]=Qmatrix(theta(i),E1,E2,E3,nu12,nu23,nu13,G12,G13,G23);
                    sigma_global{3*i-1}=Q_g*epsilon_global{3*i-1};
                    z_plot(3*i-1)=zm(i*2);
                else
                    [sigma_local{3*i},epsilon_local{3*i},epsilon_global{3*i}]      =   sigmalocal(theta(i),E1,E2,E3,nu12,nu23,nu13,G12,G13,G23,ebka_global,zm(i*2+1));
                    [Q_g]=Qmatrix(theta(i),E1,E2,E3,nu12,nu23,nu13,G12,G13,G23);
                    sigma_global{3*i}=Q_g*epsilon_global{3*i};
                    z_plot(3*i)=zm(i*2+1);
                end
            end
        end
        
        Factor{k}=factor;
        s_test=cell2mat(sigma_local);
        e_test=cell2mat(epsilon_local);
        Sigma_local{:,k}=sigma_local{10};
        Epsilon_local{:,k}=epsilon_local{10};
        
        Sigma_global{:,k}=sigma_global{10};
        Epsilon_global{:,k}=epsilon_global{10};
        
        s_local{m,k}=sigma_local{10};
        e_local{m,k}=epsilon_local{10};
        
        if m==1
            f_1(k)=factor;
        elseif m==2
            f_2(k)=factor;
        elseif m==3
            f_3(k)=factor;
        elseif m==4
            f_4(k)=factor;
        end
        SSig(k)=Sig(1);
        
        TT{m}=T;
    end
    %     F{m}=f;
    S_local=cell2mat(Sigma_local);
    E_local=cell2mat(Epsilon_local);
    S_global=cell2mat(Sigma_global);
    figure(1)
    if m==1
        plot(TT{m},S_local(2,:)./SSig,'b--')
    elseif m==2
        plot(TT{m},S_local(2,:)./SSig,'g-')
    elseif m==3
        plot(TT{m},S_local(2,:)./SSig,'k--')
    elseif m==4
        plot(TT{m},S_local(2,:)./SSig,'r-')
    end
    hold on
    grid on
    xlabel('$\theta~[^{\circ}]$','interpreter','latex', 'FontSize', 14)
    ylabel('$\sigma_{22}/\sigma_{xx}$ ; $\tau_{12}/\sigma_{xx}$','Interpreter','latex', 'FontSize', 14)
    %ylabel('$\frac{\sigma}{\sigma_{x}}$','Interpreter','latex', 'FontSize', 18)
    % axis([0,12,-0.08,0.08])
    %%figure(2)

    if m==1
        plot(TT{m},S_local(3,:)./SSig,'b--')
    elseif m==2
        plot(TT{m},S_local(3,:)./SSig,'g-')
    elseif m==3
        plot(TT{m},S_local(3,:)./SSig,'k--')
    elseif m==4
        plot(TT{m},S_local(3,:)./SSig,'r-')
    end
    hold on
    grid on
    %xlabel('$\theta$','interpreter','latex', 'FontSize', 14)
    %ylabel('$\frac{\tau_{12}}{\sigma_{x}}$','Interpreter','latex', 'FontSize', 18)
    figure(3)
        if m==1
        plot(TT{m},S_local(1,:)./SSig,'b--')
    elseif m==2
        plot(TT{m},S_local(1,:)./SSig,'b-')
    elseif m==3
        plot(TT{m},S_local(1,:)./SSig,'k--')
    elseif m==4
        plot(TT{m},S_local(1,:)./SSig,'k-')
    end
    hold on
    grid on
     xlabel('$\theta$','interpreter','latex', 'FontSize', 14)
    ylabel('$\frac{\sigma_{11}}{\sigma_{x}}$','Interpreter','latex', 'FontSize', 18)
    
    figure(4)
%     plot(TT{m},abs((S_local(3,:)./S_local(2,:))))
    if m==1
        plot(TT{m},abs((S_local(3,:)./S_local(2,:))),'b--')
    elseif m==2
        plot(TT{m},abs((S_local(3,:)./S_local(2,:))),'b-')
    elseif m==3
        plot(TT{m},abs((S_local(3,:)./S_local(2,:))),'k--')
    elseif m==4
        plot(TT{m},abs((S_local(3,:)./S_local(2,:))),'k-')
    end
    hold on
    grid on
    xlabel('$\theta$','interpreter','latex', 'FontSize', 14)
    ylabel('$\lambda=\frac{\tau_{12}}{\sigma_{22}}$','Interpreter','latex', 'FontSize', 14)
    
    
    %     figure(5)
    %     plot(T,cell2mat(Factor))
    %     hold on
    %     grid on
    %     xlabel('Laminate angle [$^\circ$]','Interpreter','latex')
    %     ylabel('factor','Interpreter','latex')
    %
    %     Factor{find(T==90)}
    
    

    
end
%%
figure(1)
%legend('location','northwest')
text(80,0.93,'\sigma_{22}','fontsize',18)
text(80,0.25,'\tau_{12}','fontsize',18)
legend('GlassFRP1','GlassFRP2','CarbonFRP1','CarbonFRP2','location','northwest','FontSize',14)
%%%text(40,0.35,'$\bar{G}_{ss}$','interpreter','latex', 'FontSize', 16)
%%%text(40,0.65,'$\bar{\psi}$','interpreter','latex', 'FontSize', 16)
%%
axis([0 90 -0.2 1.0001])
print('-f1','FigSigma','-dpng')
print('-f1','FigSigma','-depsc')

%figure(2)
%axis([0 90 -0.2 1.0])
%legend('GlassFRP1','GlassFRP2','CarbonFRP1','CarbonFRP2','location','northwest')
%print('-f2','FigSigma12','-dpng')
%print('-f2','FigSigma12','-depsc')

figure(3)
legend('GlassFRP1','GlassFRP2','CarbonFRP1','CarbonFRP2')
print('-f3','FigSigmaLegend','-dpng')
print('-f3','FigSigmaLegend','-depsc')


figure(4)
legend('GlassFRP1','GlassFRP2','CarbonFRP1','CarbonFRP2')
axis([0 90 0 100])

% figure(5)
% legend('UD E-glass','E-glass Ly556-Epoxy 55%','AS4-Graphite Ly556-Epoxy 55%','Ultra-Mod-Graphite Ly556-Epoxy 55%')

save('f.mat','f_1','f_2','f_3','f_4','TT','s_local','e_local')