##########
# Function designed to filter the localisation score columns
##########


filter_localisationscore <- function(locscores = locscores, threshold = threshold) {
  # locscores = vector of character strings with localisation scores of each PSM, separated by "&" in the case of multiple phosphorylations.
  # returns a vector with TRUE/FALSE if the localisation score passes the threshold, separated by "&" in the case of multiple phosphorylations.
  locscores <- as.character(locscores)
  locscores <- lapply(locscores, function(x) {
    strsplit(x, "&")[[1]]
  })
  locscores <- lapply(locscores, as.numeric)
  locscoreFilter <- sapply(locscores, function(x) {
    paste(x >= threshold, collapse = "&")
  })
  return(locscoreFilter)
}
