##########
# Functions designed to parse PeptideShaker output tables:
##########

extractLocalisationScore_PS <- function(PSMtable = PSMtable, PhosphoSTYProba = NULL, numberOfPhospho = NULL) {
  # Returns a list with the localisation scores of the phosphorylation in each PSM, ordered like the rows in the PSMtable
  ## Input error messages:
  #####
  if (is.null(PhosphoSTYProba) | is.null(numberOfPhospho)) {
    stop("Input the name for the field of localisation probabilities and the field for the number of phosphorylation in the PSM")
  }
  #####
  vecproba <- PSMtable[,names(PSMtable) == PhosphoSTYProba]
  vecnum <- PSMtable[,names(PSMtable) == numberOfPhospho]
  proba <- lapply(vecproba, strsplit, "), ", fixed = T)
  proba <- lapply(proba, function(x) {
    x[[1]][grepl("Phosphorylation", x[[1]], fixed = T)]
  })
  proba <- lapply(proba, strsplit, ".{1,2}: ")
  proba <- lapply(proba, function(x) {
    gsub(pattern = ",", replacement = "", unlist(x), fixed = T)[!grepl("hosphorylation", gsub(pattern = ",", replacement = "", unlist(x), fixed = T))]
    })
  proba <- lapply(proba, gsub, pattern = ")", replacement = "", fixed = T)
  proba <- lapply(which(vecnum > 0), function(x) {
    sort(as.numeric(proba[[x]]), decreasing = T)[1:vecnum[x]]
  })
  res <- vector(mode = "list", length = nrow(PSMtable))
  res[which(vecnum > 0)] <- proba
  return(res)
}


extractptmRSLocalisation_PS <- function(PSMtable = PSMtable, PhosphoSTYProba = NULL, numberOfPhospho = NULL) {
  # Returns a list with the localisations of the phosphorylation in each PSM (highest ptmRS scores), ordered like the rows in the PSMtable
  ## Input error messages:
  #####
  if (is.null(PhosphoSTYProba) | is.null(numberOfPhospho)) {
    stop("Input the name for the field of localisation probabilities and the field for the number of phosphorylation in the PSM")
  }
  #####
  vecproba <- PSMtable[,names(PSMtable) == PhosphoSTYProba]
  vecnum <- PSMtable[,names(PSMtable) == numberOfPhospho]
  proba <- lapply(vecproba, strsplit, "), ", fixed = T)
  proba <- lapply(proba, function(x) {
    x[[1]][grepl("Phosphorylation", x[[1]], fixed = T)]
  })
  loc <- lapply(proba, gsub, pattern = "Phosphorylation of [STY] \\(", replacement = "")
  loc <- lapply(loc, gsub, pattern = ")", replacement = "", fixed = T)
  loc <- lapply(loc, strsplit, ", ", fixed  = T)
  loc <- lapply(loc, function(x) {
    unlist(
      lapply(unlist(x), function(y) {
        strsplit(y, ": ", fixed = T)[[1]][1]
      })
    )
  })
  proba <- lapply(proba, strsplit, ".{1,2}: ")
  proba <- lapply(proba, function(x) {
    gsub(pattern = ",", replacement = "", unlist(x), fixed = T)[!grepl("hosphorylation", gsub(pattern = ",", replacement = "", unlist(x), fixed = T))]
  })
  proba <- lapply(proba, gsub, pattern = ")", replacement = "", fixed = T)
  loc <- lapply(which(vecnum > 0), function(x) {
    loc[[x]][order(as.numeric(proba[[x]]), decreasing = T)][1:vecnum[x]]
  })
  res <- vector(mode = "list", length = nrow(PSMtable))
  res[which(vecnum > 0)] <- loc
  return(res)
}

