##########
# Functions designed to parse MazQuant tables:
##########

extractLocalisationScore_PD <- function(PSMtable = PSMtable, PhosphoSTYProba = NULL, numberOfPhospho = NULL) {
  # Returns a list with the localisation scores of the phosphorylation in each PSM, ordered like the rows in the PSMtable
  ## Input error messages:
  #####
  if (is.null(PhosphoSTYProba) | is.null(numberOfPhospho)) {
    stop("Input the name for the field of localisation probabilities and the field for the number of phosphorylation in the PSM")
  }
  #####
  vecproba <- PSMtable[,names(PSMtable) == PhosphoSTYProba]
  vecnum <- PSMtable[,names(PSMtable) == numberOfPhospho]
  proba <- sapply(vecproba, strsplit, ": ", fixed = T)
  proba <- sapply(proba, function(x) {
    x[!grepl(")", x, fixed = T) | grepl(";", x, fixed = T)]
  })
  proba <- lapply(which(vecnum > 0), function(x) {
    sort(
      as.numeric(
        sapply(proba[[x]], function(y) {
          strsplit(y, "; ", fixed = T)[[1]][1]
        })
      ), decreasing = T
    )[1:vecnum[x]]
  })
  res <- vector(mode = "list", length = nrow(PSMtable))
  res[which(vecnum > 0)] <- proba
  return(res)
}


extractptmRSLocalisation_PD <- function(PSMtable = PSMtable, PhosphoSTYProba = NULL, numberOfPhospho = NULL) {
  # Returns a list with the localisations of the phosphorylation in each PSM (highest ptmRS scores), ordered like the rows in the PSMtable
  ## Input error messages:
  #####
  if (is.null(PhosphoSTYProba) | is.null(numberOfPhospho)) {
    stop("Input the name for the field of localisation probabilities and the field for the number of phosphorylation in the PSM")
  }
  #####
  vecproba <- PSMtable[,names(PSMtable) == PhosphoSTYProba]
  vecnum <- PSMtable[,names(PSMtable) == numberOfPhospho]
  loc <- sapply(vecproba, strsplit, "(", fixed = T)
  loc <- sapply(loc, function(x) {
    as.numeric(gsub(").+$", "", x[grepl(")", x, fixed = T)]))
  })
  proba <- sapply(vecproba, strsplit, ": ", fixed = T)
  proba <- sapply(proba, function(x) {
    x[!grepl(")", x, fixed = T) | grepl(";", x, fixed = T)]
  })
  loc <- lapply(which(vecnum > 0), function(x) {
    loc[[x]][order(
      as.numeric(
        sapply(proba[[x]], function(y) {
          strsplit(y, "; ", fixed = T)[[1]][1]
        })
      ), decreasing = T
    )][1:vecnum[x]]
  })
  res <- vector(mode = "list", length = nrow(PSMtable))
  res[which(vecnum > 0)] <- loc
  return(res)
}
