
# physical constants in cgs 

# Fundamental constants taken from NIST's 2010 CODATA recommended values

c      = 2.99792458e10     # speed of light
h      = 6.62606957e-27    # Planck constant
hbar   = 1.054571726e-27   #
G      = 6.67428e-8        # Gravitational constant
e      = 4.80320451e-10    # Electron charge
me     = 9.10938291e-28    # Electron mass
mp     = 1.672621777e-24   # Proton mass
NA     = 6.02214129e23     # Avogadro constant
k      = 1.3806488e-16     # Boltzmann constant
R      = 8.3144621454689518e7       # gas constant = k * NA
                                    # This is how the value of R in CASTRO
sigma  = 5.670373e-5       # Stefan-Boltzmann constant
sigmaT = 6.652458734e-25   # Thomson cross section
a      = 7.5657313567241239e-15      # Radiation density constant
                                     # a = 4.*sigma/c
                                     # because this is how a is computed in CASTRO

# conversion factor
eV     = 1.602176487e-12   # Electron volt
J      = 1.0e7            # 1 Joule = 10^7 erg
N      = 1.0e5            # 1 N = 10^5 dyn

# astronomical quantities
AU     = 1.496e13         # Astronomical Unit
pc     = 3.086e18         # Parsec
ly     = 9.463e17         # light year
Jy     = 1.0e-23          # Jansky
mJy    = 1.0e-23          # mJansky
Msun   = 1.98892e33       # Solar mass
Lsun   = 3.839e33         # Solar Luminosity
Rsun   = 6.955e11         # Solar radius
Mbolsun = 4.7554          # Absolute Bolometric Magnitude of Sun

# time
year   = 3.1556926e7      # year in second 
day    = 86400.0          # day in second

