% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{norm2trunc}
\alias{norm2trunc}
\title{Convert normal to truncated normal}
\usage{
norm2trunc(x, min = -Inf, max = Inf, mu = mean(x),
  sd = stats::sd(x))
}
\arguments{
\item{x}{the normally distributed vector}

\item{min}{the minimum of the truncated distribution to return}

\item{max}{the maximum of the truncated distribution to return}

\item{mu}{the mean of the distribution to return (calculated from x if not given)}

\item{sd}{the SD of the distribution to return (calculated from x if not given)}
}
\value{
a vector with a uniform distribution
}
\description{
Convert a normal (gaussian) distribution to a truncated normal distribution with specified minimum and maximum
}
\examples{

x <- rnorm(10000)
y <- norm2trunc(x, 1, 7, 3.5, 2)
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
