% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{norm2binom}
\alias{norm2binom}
\title{Convert normal to binomial}
\usage{
norm2binom(x, size = 1, prob = 0.5, mu = mean(x),
  sd = stats::sd(x))
}
\arguments{
\item{x}{the normally distributed vector}

\item{size}{number of trials (0 or more)}

\item{prob}{the probability of success on each trial (0 to 1)}

\item{mu}{the mean of x (calculated from x if not given)}

\item{sd}{the SD of x (calculated from x if not given)}
}
\value{
a vector with a binomial distribution
}
\description{
Convert normal to binomial
}
\examples{

x <- rnorm(10000)
y <- norm2binom(x)
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
