% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_params.R
\name{get_params}
\alias{get_params}
\alias{check_sim_stats}
\title{Get parameters from a data table}
\usage{
get_params(data, between = c(), within = c(), dv = "y", id = "id",
  digits = 2)

check_sim_stats(data, between = c(), within = c(), dv = "y",
  id = "id", digits = 2)
}
\arguments{
\item{data}{the existing tbl}

\item{between}{a vector of column names for between-subject factors}

\item{within}{a vector of column names for within-subject factors (if data is long)}

\item{dv}{the column name of the dv (if data is long)}

\item{id}{the column name(s) of the subject ID (if data is long)}

\item{digits}{how many digits to round to (default = 2)}
}
\value{
a tbl of correlations, means and sds
}
\description{
\code{get_params} Generates a table of the correlations and means of numeric columns in a data frame
}
\examples{
get_params(iris, "Species")
}
