% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_name_labels.R
\name{fix_name_labels}
\alias{fix_name_labels}
\title{Fix name labels}
\usage{
fix_name_labels(x, pattern = "(\\\\W|_)", replacement = ".")
}
\arguments{
\item{x}{the vector or list to fix}

\item{pattern}{regex pattern to replace with full stops (defaults to non-word characters and underscores)}

\item{replacement}{the character to replace (defaults to .)}
}
\value{
a named list with fixed names
}
\description{
Fixes if a factor list does not have named levels or has special characters in the names
}
\examples{
source <- list("full.stop", " space ", "under_score", "plus+", "dash-", "tab\\t", "line\\nbreak")
fix_name_labels(source)

}
