% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faux2ANOVA_design.R
\name{faux2ANOVA_design}
\alias{faux2ANOVA_design}
\title{Convert faux design to ANOVApower design}
\usage{
faux2ANOVA_design(design, plot = TRUE)
}
\arguments{
\item{design}{faux design list (e.g., from check_design)}

\item{plot}{whether to show the plot from ANOVApower::ANOVA_design}
}
\value{
a design list for ANOVApower
}
\description{
Convert faux design to ANOVApower design
}
\examples{
within <- list(pet = c(dog = "Dog Owners", cat = "Cat Owners"))
between <- list(time = c("day" = "Before 7pm", "night" = "After 7pm"))
faux_des <- check_design(within, between, n = 50, mu = 1:4, sd = 2, r = 0.5)
apower_des <- faux2ANOVA_design(faux_des)

}
