#
# Copyright (c) Istituto Nazionale di Fisica Nucleare, 2018.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

import unittest
from tempfile import mkstemp
from VOMSHelperLibrary import VOMSHelperLibrary
import os

TEST_INPUT="""-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
-----BEGIN RSA PRIVATE KEY-----
MIICXAIBAAKBgQCQKADIZNNNqnyocoN9p4LtUgWvxkX9o3ymFPwX07QJzDWCPyCT
UbYAM3WIBSeeVidoM58N03xKFQDuRMbzJo0sfcy7oU2+4KfFHBS9geKGQKyzWXY6
y2d8aUAcZXKn1oXsJX9P6CQrFMvX4UUQFgNRRrob8oVuy0tVOI+SAgxTKwIDAQAB
AoGAW9Rfy0gPIuZ7yoJIKP9QdAVQAgz4AP7oJJQxkqwVgDhJzdKQ2cevfKlLMX63
IjIXoFVh+NjD0B1ZHm9JnRLt0nj58TFlbXzr8r5NCiMFPCcjAiJEiSqO1KM7dCoZ
jBFvsavQP+jVs9FL0RbB2BxnZFQ/syS6ZRuqJSkIatO5wcECQQDC9LUt76vX2zOL
loTDTrV+p53v+HiRpue/ccaD5eH2vhopWb1RgYW2G6pYsPitYgmCHzYYDAp85fe+
Tslt1hVZAkEAvUtLR9apVArliPCRrtvVyKwQNExDsMmJ1XDjFHW0Bh6U6bbg/4g/
7X4/npY1MlPqBhII4H+o5hUapLnhNE2oIwJBAKI5ikHtO6tkxaGT4Gm8px37UFsN
ARcCMbmGbU/4DG2Lhq199SFLi/4bS0Z+DJAKEitq2VJtQpTnr512Zfq1uBECQHvl
X0WK49OFOk1SIBhR/PBWZljEnf2FO/j+5TJMA+OJerAqKcQ22pjIbD2RVQo20FLe
1P6Tr+nAYGr22scQGP8CQGp632d+bJRkzxfqC8L+IyqEuNBU1UUvhplmIx2wIx9l
Y9wlt+hiieTcddOHafxTq3I9MSldjB1lfgHTYpvwwyI=
-----END RSA PRIVATE KEY-----
-----BEGIN CERTIFICATE-----
MIIDnjCCAoagAwIBAgIBCTANBgkqhkiG9w0BAQUFADAtMQswCQYDVQQGEwJJVDEM
MAoGA1UECgwDSUdJMRAwDgYDVQQDDAdUZXN0IENBMB4XDTEyMDkyNjE1MzkzNFoX
DTIyMDkyNDE1MzkzNFowKzELMAkGA1UEBhMCSVQxDDAKBgNVBAoTA0lHSTEOMAwG
A1UEAxMFdGVzdDAwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDKxtrw
hoZ27SxxISjlRqWmBWB6U+N/xW2kS1uUfrQRav6auVtmtEW45J44VTi3WW6Y113R
BwmS6oW+3lzyBBZVPqnhV9/VkTxLp83gGVVvHATgGgkjeTxIsOE+TkPKAoZJ/QFc
CfPh3WdZ3ANI14WYkAM9VXsSbh2okCsWGa4o6pzt3Pt1zKkyO4PW0cBkletDImJK
2vufuDVNm7Iz/y3/8pY8p3MoiwbF/PdSba7XQAxBWUJMoaleh8xy8HSROn7tF2al
xoDLH4QWhp6UDn2rvOWseBqUMPXFjsUi1/rkw1oHAjMroTk5lL15GI0LGd5dTVop
kKXFbTTYxSkPz1MLAgMBAAGjgcowgccwDAYDVR0TAQH/BAIwADAdBgNVHQ4EFgQU
fLdB5+jO9LyWN2/VCNYgMa0jvHEwDgYDVR0PAQH/BAQDAgXgMD4GA1UdJQQ3MDUG
CCsGAQUFBwMBBggrBgEFBQcDAgYKKwYBBAGCNwoDAwYJYIZIAYb4QgQBBggrBgEF
BQcDBDAfBgNVHSMEGDAWgBSRdzZ7LrRp8yfqt/YIi0ojohFJxjAnBgNVHREEIDAe
gRxhbmRyZWEuY2VjY2FudGlAY25hZi5pbmZuLml0MA0GCSqGSIb3DQEBBQUAA4IB
AQANYtWXetheSeVpCfnId9TkKyKTAp8RahNZl4XFrWWn2S9We7ACK/G7u1DebJYx
d8POo8ClscoXyTO2BzHHZLxauEKIzUv7g2GehI+SckfZdjFyRXjD0+wMGwzX7MDu
SL3CG2aWsYpkBnj6BMlr0P3kZEMqV5t2+2Tj0+aXppBPVwzJwRhnrSJiO5WIZAZf
49YhMn61sQIrepvhrKEUR4XVorH2Bj8ek1/iLlgcmFMBOds+PrehSRR8Gn0IjlEg
C68EY6KPE+FKySuS7Ur7lTAjNdddfdAgKV6hJyST6/dx8ymIkb8nxCPnxCcT2I2N
vDxcPMc/wmnMa+smNal0sJ6m
-----END CERTIFICATE-----"""

TEST_EXPECTED="""-----BEGIN CERTIFICATE-----
MIIDnjCCAoagAwIBAgIBCTANBgkqhkiG9w0BAQUFADAtMQswCQYDVQQGEwJJVDEM
MAoGA1UECgwDSUdJMRAwDgYDVQQDDAdUZXN0IENBMB4XDTEyMDkyNjE1MzkzNFoX
DTIyMDkyNDE1MzkzNFowKzELMAkGA1UEBhMCSVQxDDAKBgNVBAoTA0lHSTEOMAwG
A1UEAxMFdGVzdDAwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDKxtrw
hoZ27SxxISjlRqWmBWB6U+N/xW2kS1uUfrQRav6auVtmtEW45J44VTi3WW6Y113R
BwmS6oW+3lzyBBZVPqnhV9/VkTxLp83gGVVvHATgGgkjeTxIsOE+TkPKAoZJ/QFc
CfPh3WdZ3ANI14WYkAM9VXsSbh2okCsWGa4o6pzt3Pt1zKkyO4PW0cBkletDImJK
2vufuDVNm7Iz/y3/8pY8p3MoiwbF/PdSba7XQAxBWUJMoaleh8xy8HSROn7tF2al
xoDLH4QWhp6UDn2rvOWseBqUMPXFjsUi1/rkw1oHAjMroTk5lL15GI0LGd5dTVop
kKXFbTTYxSkPz1MLAgMBAAGjgcowgccwDAYDVR0TAQH/BAIwADAdBgNVHQ4EFgQU
fLdB5+jO9LyWN2/VCNYgMa0jvHEwDgYDVR0PAQH/BAQDAgXgMD4GA1UdJQQ3MDUG
CCsGAQUFBwMBBggrBgEFBQcDAgYKKwYBBAGCNwoDAwYJYIZIAYb4QgQBBggrBgEF
BQcDBDAfBgNVHSMEGDAWgBSRdzZ7LrRp8yfqt/YIi0ojohFJxjAnBgNVHREEIDAe
gRxhbmRyZWEuY2VjY2FudGlAY25hZi5pbmZuLml0MA0GCSqGSIb3DQEBBQUAA4IB
AQANYtWXetheSeVpCfnId9TkKyKTAp8RahNZl4XFrWWn2S9We7ACK/G7u1DebJYx
d8POo8ClscoXyTO2BzHHZLxauEKIzUv7g2GehI+SckfZdjFyRXjD0+wMGwzX7MDu
SL3CG2aWsYpkBnj6BMlr0P3kZEMqV5t2+2Tj0+aXppBPVwzJwRhnrSJiO5WIZAZf
49YhMn61sQIrepvhrKEUR4XVorH2Bj8ek1/iLlgcmFMBOds+PrehSRR8Gn0IjlEg
C68EY6KPE+FKySuS7Ur7lTAjNdddfdAgKV6hJyST6/dx8ymIkb8nxCPnxCcT2I2N
vDxcPMc/wmnMa+smNal0sJ6m
-----END CERTIFICATE-----"""

class VOMSHelperLibraryTest(unittest.TestCase):
    
    def test_extract_eec_from_proxy_returns(self):
        l = VOMSHelperLibrary()
        (fd, name) = mkstemp()
        with open(name, "w") as f:
            f.write(TEST_INPUT)
            f.close()
        (result,dest_file) = l.extract_eec_from_proxy(name)
        
        self.assertEqual(result,TEST_EXPECTED)
        self.assertTrue(os.path.exists(dest_file))
    
    def test_extract_eec_from_proxy_writes_to_dest(self):
        l = VOMSHelperLibrary()
        (fd, name) = mkstemp()
        with open(name, "w") as f:
            f.write(TEST_INPUT)
            f.close()
        (fd2, dname) = mkstemp()
        l.extract_eec_from_proxy(name,dname)
        with open(dname) as d:
            result = ''.join(d.readlines())
        self.assertEqual(result, TEST_EXPECTED)
        
if __name__ == '__main__':
    unittest.main()
    