<p align="center"><img src="https://gis4wrf.github.io/assets/images/gis4wrf_logo.png"></p>

# GIS4WRF

| Build and Tests | Documentation | Article DOI | Software DOI |
|-----------------|---------------|-------------|--------------|
[![Build Status](https://travis-ci.com/GIS4WRF/gis4wrf.svg?branch=master)](https://travis-ci.com/GIS4WRF/gis4wrf) | [![docs](https://img.shields.io/badge/docs-gis4wrf.github.io-blue.svg)](https://gis4wrf.github.io) | [![DOI](https://img.shields.io/badge/DOI-10.1016%2Fj.envsoft.2018.10.018-brightgreen.svg)](https://doi.org/10.1016/j.envsoft.2018.10.018) | [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1288569.svg)](https://doi.org/10.5281/zenodo.1288569) |

GIS4WRF is a free and open source [QGIS](https://qgis.org/) plug-in to help researchers and practitioners with their [Advanced Research Weather Research and Forecasting](https://www.mmm.ucar.edu/weather-research-and-forecasting-model) modelling workflows. GIS4WRF can be used to pre-process input data, run simulations, and visualize or post-process results. We offer MPI-enabled pre-built binary distributions for Windows, macOS and Linux through [WRF-CMake](https://github.com/WRF-CMake/WRF). For information on how to install GIS4WRF, or check out the main documentation and tutorials, please refer to the GIS4WRF website at https://gis4wrf.github.io.

<p align="center"><img src="https://gis4wrf.github.io/assets/images/gis4wrf-demo.gif"></p>
<p align="center">Configure, run and visualize a WRF simulation in GIS4WRF</p>


## Citing
If you use GIS4WRF in a published work, please cite both the paper (https://doi.org/10.1016/j.envsoft.2018.10.018), and the specific version of GIS4WRF you are using (https://doi.org/10.5281/zenodo.1288569).

### Example

```
Meyer, D., & Riechert, M. (2019). Open source QGIS toolkit for the Advanced Research WRF
modelling system. Environmental Modelling & Software, 112, 166–178.
https://doi.org/10.1016/j.envsoft.2018.10.018

Meyer, D., & Riechert, M. (2018). The GIS4WRF Plugin. Zenodo.
https://doi.org/10.5281/zenodo.1288569
```


## Contributing

If you would like to contribute to the GIS4WRF project, clone this repository, make your changes, and create a pull request with a **clear description** of your changes. If your changes are merged, you will appear as one of our [Contributors](https://github.com/GIS4WRF/gis4wrf/graphs/contributors).


## Versioning

This project uses [semantic versioning](https://semver.org/).


## Copyright and licence

Copyright 2018 D. Meyer and M. Riechert. Licensed under [MIT](LICENSE.txt).