% This file is a wrapper around the direct_kernel function which is
% based on Appendix D of "Direct Nonlinear Shrinkage Estimation of
% Large-Dimensional Covariance Matrices" by Olivier Ledoit and Michael
% Wolf, Working Paper No. 264, Department of Economics, University of
% Zurich (Switzerland), available from the official academic website of 
% Professor Michael Wolf. The wrapper calls the direct_kernel function to
% estimate the covariance (sigmahat) which is then used to calculate the Mahalanobis
% distance (d), which is the distance of point Y to the distribution X.

function d=mahalkernel(Y,X)
    
    mu=mean(X,1);
    
    %standardise data
    mustd=std([X;Y],[],1);
    mustdrep=repmat(mustd,size([X;Y],1),1);
    Xout=[X;Y]./mustdrep;
    X=Xout(1:end-1,:);
    Y=Xout(end,:);
        
    %compute covariance
    sigmahat=direct_kernel(X,1);
    
    %eq 1 from the paper
    d=sqrt( (Y-mu) * inv(sigmahat) * (Y-mu)');
end