/***************************************************************************/
/**                                                                       **/
/**                 c  u  t  c  l  m  .  c                                **/
/**                                                                       **/
/**     Function cuts input from CLM file with new start year             **/
/**                                                                       **/
/**     written by Werner von Bloh                                        **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-04-25 16:34:30 +0200 (Mon, 25 Apr 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

#define USAGE "Usage: cutclm [-longheader] [-size4] [-end] year src.clm dst.clm\n"

int main(int argc,char **argv)
{
  FILE *file,*out;
  char *endptr;
  Header header;
  Bool swap,istail;
  int version,year,index,idata,i;
  long long size;
  short sdata;
  String id;
  size=2;
  istail=FALSE;
  version=READ_VERSION;
  for(index=1;index<argc;index++)
  {
    if(argv[index][0]=='-')
    {
      if(!strcmp(argv[index],"-size4"))
        size=4;
      else if(!strcmp(argv[index],"-end"))
        istail=TRUE;
      else if(!strcmp(argv[index],"-longheader"))
        version=2;
      else
      {
        fprintf(stderr,"Invalid option '%s'.\n"
                USAGE,argv[index]);
        return EXIT_FAILURE;
      }
    }
    else
      break;
  }
   if(argc<index+3)
  {
    fprintf(stderr,"Argument(s) missing.\n"
            USAGE);
    return EXIT_FAILURE;
  }
  year=strtol(argv[index],&endptr,10);
  if(*endptr!='\0')
  {
    fprintf(stderr,"Invalid number '%s' for year.\n",argv[index]);
    return EXIT_FAILURE;
  }
  file=fopen(argv[index+1],"rb");
  if(file==NULL)
  {
    fprintf(stderr,"Error opening '%s': %s\n",argv[index+1],strerror(errno));
    return EXIT_FAILURE;
  }
  if(freadanyheader(file,&header,&swap,id,&version))
  {
    fprintf(stderr,"Error reading header in '%s'.\n",
            argv[index+1]);
    return EXIT_FAILURE;
  }
  if(year<header.firstyear || year>=header.firstyear+header.nyear)
  {
     fprintf(stderr,"Invalid year %d, must be in [%d,%d].\n",year,header.firstyear,header.firstyear+header.nyear-1);
    return EXIT_FAILURE;
  }
  out=fopen(argv[index+2],"wb");
  if(out==NULL)
  {
    fprintf(stderr,"Error creating '%s': %s\n",argv[index+2],strerror(errno));
    return EXIT_FAILURE;
  }
  if(istail)
    header.nyear=year-header.firstyear+1;
  else
  {
    if(fseek(file,size*(year-header.firstyear)*header.nbands*header.ncell,SEEK_CUR))
    {
      fprintf(stderr,"Error seeking in '%s' to year %d.\n",argv[index+1],year);
      return EXIT_FAILURE;
    }
    header.nyear-=year-header.firstyear;
    header.firstyear=year;
  }
  fwriteheader(out,header,id,version);
  switch(size)
  {
    case 2:
      for(i=0;i<header.nyear*header.nbands*header.ncell;i++)
      {
        if(freadshort(&sdata,1,swap,file)!=1)
        {
          fprintf(stderr,"Error reading input from '%s'.\n",argv[index+1]);
          return EXIT_FAILURE;
        }
        fwrite(&sdata,sizeof(short),1,out);
      }
      break;
    case 4:
      for(i=0;i<header.nyear*header.nbands*header.ncell;i++)
      {
        if(freadint(&idata,1,swap,file)!=1)
        {
          fprintf(stderr,"Error reading input from '%s'.\n",argv[index+1]);
          return EXIT_FAILURE;
        }
        fwrite(&idata,sizeof(int),1,out);
      }
      break;
  }
  fclose(file);
  fclose(out);
  return EXIT_SUCCESS;
} /* of 'main' */
