/***************************************************************************/
/**                                                                       **/
/**               v  m  a  x  l  i  m  i  t  _  t  r  e  e  .  c          **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von BLoh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-02-23 12:38:53 +0100 (Thu, 23 Feb 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"

Real vmaxlimit_tree(const Pft *pft, /* pointer to PFT */
                    Real daylength, /* day length (h) */
                    Real temp       /* temperature (deg C) */
                   )                /* returns vmax (gC/m2/day) */
{
  const Pfttree *tree;
  tree=pft->data; 
  //return (n_leaf-param.n0*0.001*(tree->ind.leaf.carbon*pft->nind+pft->bm_inc.carbon*tree->falloc.leaf))/exp(-0.0555*(temp-25))/f_lai(lai_tree(pft))/param.p/0.02314815*daylength;
  return (tree->ind.leaf.nitrogen-param.n0*0.001*tree->ind.leaf.carbon*pft->nind)/exp(-param.k_temp*(temp-25))/f_lai(lai_tree(pft))/param.p/0.02314815*daylength;
} /* of 'vmaxlimit_tree' */
