/***************************************************************************/
/**                                                                       **/
/**        t u r n o v e r _ m o n t h l y _ t r e e . c                  **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-06-09 09:18:57 +0200 (Thu, 09 Jun 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"

void turnover_monthly_tree(Litter *litter,Pft *pft)
{
  Pfttree *tree;
  Pfttreepar *treepar;  
  treepar=pft->par->data;
  tree=pft->data;
  tree->turn.root.carbon+=tree->ind.root.carbon*treepar->turnover.root/NMONTH;
  tree->turn_litt.root.carbon+=tree->ind.root.carbon*treepar->turnover.root/NMONTH*pft->nind;
  litter->bg[pft->litter].carbon+=tree->ind.root.carbon*treepar->turnover.root/NMONTH*pft->nind;
  tree->turn.root.nitrogen+=tree->ind.root.nitrogen*treepar->turnover.root/NMONTH;
  //tree->turn_nbminc+=tree->ind.root.nitrogen*treepar->turnover.root/NMONTH*pft->nind*(1-pft->par->fn_turnovern);
  tree->turn_litt.root.nitrogen+=tree->ind.root.nitrogen*treepar->turnover.root/NMONTH*pft->nind;//*pft->par->fn_turnover;
  litter->bg[pft->litter].nitrogen+=tree->ind.root.nitrogen*treepar->turnover.root/NMONTH*pft->nind*pft->par->fn_turnover;
  tree->turn_nbminc+= tree->ind.root.nitrogen*treepar->turnover.root/NMONTH*pft->nind*(1-pft->par->fn_turnover);
  /* add collected N from turnover to pft->bminc.nitrogen */
 // pft->bm_inc.nitrogen+=tree->turn_nbminc;
  //tree->turn_nbminc=0;

} /* of 'turnover_monthly_tree' */
