/***************************************************************************/
/**                                                                       **/
/**        t u r n o v e r _ d a i l y _ t r e e . c                      **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date::                                            $ **/
/**     By         : $Author::                                 $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"

void turnover_daily_tree(Litter *litter,Pft *pft,Real temp)
{
  Pfttree *tree;
  Pfttreepar *treepar;
  Real dtemp;
  tree = pft->data;
  treepar = pft->par->data;
  dtemp=temp - getpftpar(pft,gddbase);
  switch(getpftpar(pft,phenology))
  {
    case SUMMERGREEN:
      if(pft->aphen>treepar->aphen_max && !tree->isphen && tree->turn.leaf.carbon<epsilon)
      {
        tree->turn.leaf.carbon += tree->ind.leaf.carbon*treepar->turnover.leaf;
        tree->turn_litt.leaf.carbon += tree->ind.leaf.carbon*treepar->turnover.leaf*pft->nind;
        pft->stand->soil.litter.ag[pft->litter].trait.leaf.carbon += tree->ind.leaf.carbon*treepar->turnover.leaf*pft->nind;
        tree->turn.leaf.nitrogen += tree->ind.leaf.nitrogen*treepar->turnover.leaf;
        tree->turn_litt.leaf.nitrogen += tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind;
        pft->stand->soil.litter.ag[pft->litter].trait.leaf.nitrogen += tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind;
        update_fbd_tree(&pft->stand->soil.litter,pft->par->fuelbulkdensity,tree->ind.leaf.carbon*treepar->turnover.leaf*pft->nind,0);
        tree->isphen=TRUE;
      }
      else if(dtemp<0 && pft->aphen>treepar->aphen_min && !tree->isphen && tree->turn.leaf.carbon<epsilon)
      {
          tree->isphen=TRUE;
          tree->turn.leaf.carbon += tree->ind.leaf.carbon*treepar->turnover.leaf;
          tree->turn_litt.leaf.carbon += tree->ind.leaf.carbon*treepar->turnover.leaf*pft->nind;
          pft->stand->soil.litter.ag[pft->litter].trait.leaf.carbon += tree->ind.leaf.carbon*treepar->turnover.leaf*pft->nind;
          tree->turn.leaf.nitrogen += tree->ind.leaf.nitrogen*treepar->turnover.leaf;
          tree->turn_litt.leaf.nitrogen += tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind;
          pft->stand->soil.litter.ag[pft->litter].trait.leaf.nitrogen += tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind;
          update_fbd_tree(&pft->stand->soil.litter,pft->par->fuelbulkdensity,tree->ind.leaf.carbon*treepar->turnover.leaf*pft->nind,0);

      }
      break;
/*    case RAINGREEN:
      if(tree->aphen_raingreen>80 && !tree->isphen && tree->turn.leaf<epsilon && pft->phen<0.8)
      {
    	  tree->isphen=TRUE;
     	  tree->turn.leaf+=tree->ind.leaf*treepar->turnover.leaf;
    	  tree->turn_litt.leaf+=tree->ind.leaf*treepar->turnover.leaf*pft->nind;
    	  pft->stand->soil.litter.ag[pft->litter].trait.leaf+=tree->ind.leaf*treepar->turnover.leaf*pft->nind;
    	  update_fbd_tree(&pft->stand->soil.litter,pft->par->fuelbulkdensity,tree->ind.leaf*treepar->turnover.leaf*pft->nind,0);
      }
      break;*/
//    case EVERGREEN:
      default:
        tree->turn.leaf.carbon += tree->ind.leaf.carbon*treepar->turnover.leaf / NDAYYEAR;
        tree->turn_litt.leaf.carbon += tree->ind.leaf.carbon*treepar->turnover.leaf / NDAYYEAR*pft->nind;
        litter->ag[pft->litter].trait.leaf.carbon += tree->ind.leaf.carbon*treepar->turnover.leaf / NDAYYEAR*pft->nind;
        tree->turn.leaf.nitrogen += tree->ind.leaf.nitrogen*treepar->turnover.leaf / NDAYYEAR;
        tree->turn_litt.leaf.nitrogen += tree->ind.leaf.nitrogen*treepar->turnover.leaf / NDAYYEAR*pft->nind;
        litter->ag[pft->litter].trait.leaf.nitrogen += tree->ind.leaf.nitrogen*treepar->turnover.leaf / NDAYYEAR*pft->nind;
        update_fbd_tree(litter,pft->par->fuelbulkdensity,tree->ind.leaf.carbon*treepar->turnover.leaf/NDAYYEAR*pft->nind,0);
      break;
  } /*switch*/
} /* of 'turnover_daily_tree' */
