/***************************************************************************/
/**                                                                       **/
/**             p  h  e  n  o  l  o  g  y  _  t  r  e  e  .  c            **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-06-09 09:18:57 +0200 (Thu, 09 Jun 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"

void phenology_tree(Pft *pft,  /* pointer to PFT variables */
                    Real temp, /* temperature (deg C) */
                    int day    /* day of year (1..365) */
                   )
{
  Pfttree *tree;
  Real dtemp,gddtw;
  Pfttreepar *treepar; 
  tree=pft->data;
  treepar=pft->par->data;
  dtemp=temp - getpftpar(pft,gddbase);
  gddtw=temp - getpftpar(pft,twmax);
  if(dtemp>0.0)
    pft->gdd+=dtemp;
  tree->gddtw+= (gddtw>0.0) ? gddtw : 0.0;  
  switch(getpftpar(pft,phenology))
  {
    case SUMMERGREEN: 
      if(pft->aphen<treepar->aphen_max)
      {
        pft->phen=pft->gdd*getpftpar(pft,ramp);
        if(pft->phen>1)
          pft->phen=1;
      }
      else
      {
         if(!tree->isphen)
         {
           tree->turn.leaf.carbon+=tree->ind.leaf.carbon*treepar->turnover.leaf;
           tree->turn.leaf.nitrogen+=tree->ind.leaf.nitrogen*treepar->turnover.leaf;
           //tree->turn_nbminc+=tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind*(1-pft->par->fn_turnover);
           tree->turn_litt.leaf.carbon+=tree->ind.leaf.carbon*treepar->turnover.leaf*pft->nind;
           tree->turn_litt.leaf.nitrogen+=tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind;//*pft->par->fn_turnover;
           pft->stand->soil.litter.ag[pft->litter].trait.leaf.carbon+=tree->ind.leaf.carbon*treepar->turnover.leaf*pft->nind;
           pft->stand->soil.litter.ag[pft->litter].trait.leaf.nitrogen+=tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind*pft->par->fn_turnover;
           tree->turn_nbminc+= tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind*(1-pft->par->fn_turnover);
           update_fbd_tree(&pft->stand->soil.litter,pft->par->fuelbulkdensity,tree->ind.leaf.carbon*treepar->turnover.leaf*pft->nind,0);
           pft->phen=0.0;
         }
         tree->isphen=TRUE;
      }
      /* cold-induced senescence;
         works only for linearly interpolated, monthly temperature data! */
      if(dtemp<0 && pft->aphen>treepar->aphen_min && !tree->isphen && tree->turn.leaf.carbon<epsilon) 
      {
        tree->isphen=TRUE;
        pft->phen=pft->gdd=0.0;
        tree->turn.leaf.carbon+=tree->ind.leaf.carbon*treepar->turnover.leaf;
        tree->turn.leaf.nitrogen+=tree->ind.leaf.nitrogen*treepar->turnover.leaf;
        //tree->turn_nbminc+=tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind*(1-pft->par->fn_turnover);
        tree->turn_litt.leaf.carbon+=tree->ind.leaf.carbon*treepar->turnover.leaf*pft->nind;
        tree->turn_litt.leaf.nitrogen+=tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind;//*pft->par->fn_turnover;
        pft->stand->soil.litter.ag[pft->litter].trait.leaf.carbon+=tree->ind.leaf.carbon*treepar->turnover.leaf*pft->nind;
        pft->stand->soil.litter.ag[pft->litter].trait.leaf.nitrogen+=tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind*pft->par->fn_turnover;
        tree->turn_nbminc+= tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind*(1-pft->par->fn_turnover);
        update_fbd_tree(&pft->stand->soil.litter,pft->par->fuelbulkdensity,tree->ind.leaf.carbon*treepar->turnover.leaf*pft->nind,0);
      }
      break;
    case RAINGREEN: 
      tree->turn.leaf.carbon+=tree->ind.leaf.carbon*treepar->turnover.leaf/NDAYYEAR;
      tree->turn.leaf.nitrogen+=tree->ind.leaf.nitrogen*treepar->turnover.leaf/NDAYYEAR;
      //tree->turn_nbminc+=tree->ind.leaf.nitrogen*treepar->turnover.leaf/NDAYYEAR*pft->nind*(1-pft->par->fn_turnover);
      tree->turn_litt.leaf.carbon+=tree->ind.leaf.carbon*treepar->turnover.leaf/NDAYYEAR*pft->nind;
      tree->turn_litt.leaf.nitrogen+=tree->ind.leaf.nitrogen*treepar->turnover.leaf/NDAYYEAR*pft->nind;//*pft->par->fn_turnover;
      pft->stand->soil.litter.ag[pft->litter].trait.leaf.carbon+=tree->ind.leaf.carbon*treepar->turnover.leaf/NDAYYEAR*pft->nind;
      pft->stand->soil.litter.ag[pft->litter].trait.leaf.nitrogen+=tree->ind.leaf.nitrogen*treepar->turnover.leaf/NDAYYEAR*pft->nind*pft->par->fn_turnover;
      tree->turn_nbminc+= tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind*(1-pft->par->fn_turnover)/NDAYYEAR;
      update_fbd_tree(&pft->stand->soil.litter,pft->par->fuelbulkdensity,tree->ind.leaf.carbon*treepar->turnover.leaf/NDAYYEAR*pft->nind,0);

      if(pft->wscal<getpftpar(pft,minwscal)) 
        pft->phen=0.0;
      else
      {
        pft->phen=1.0;
        tree->aphen_raingreen++;
      }
      break;
    case EVERGREEN:
      pft->phen=1;
      tree->turn.leaf.carbon+=tree->ind.leaf.carbon*treepar->turnover.leaf/NDAYYEAR;
      tree->turn.leaf.nitrogen+=tree->ind.leaf.nitrogen*treepar->turnover.leaf/NDAYYEAR;
      //tree->turn_nbminc+=tree->ind.leaf.nitrogen*treepar->turnover.leaf/NDAYYEAR*pft->nind*(1-pft->par->fn_turnover);
      tree->turn_litt.leaf.carbon+=tree->ind.leaf.carbon*treepar->turnover.leaf/NDAYYEAR*pft->nind;
      tree->turn_litt.leaf.nitrogen+=tree->ind.leaf.nitrogen*treepar->turnover.leaf/NDAYYEAR*pft->nind;//*pft->par->fn_turnover;
      pft->stand->soil.litter.ag[pft->litter].trait.leaf.carbon+=tree->ind.leaf.carbon*treepar->turnover.leaf/NDAYYEAR*pft->nind;
      pft->stand->soil.litter.ag[pft->litter].trait.leaf.nitrogen+=tree->ind.leaf.nitrogen*treepar->turnover.leaf/NDAYYEAR*pft->nind*pft->par->fn_turnover;
      tree->turn_nbminc+= tree->ind.leaf.nitrogen*treepar->turnover.leaf*pft->nind*(1-pft->par->fn_turnover)/NDAYYEAR;
      update_fbd_tree(&pft->stand->soil.litter,pft->par->fuelbulkdensity,tree->ind.leaf.carbon*treepar->turnover.leaf/NDAYYEAR*pft->nind,0);
      break;
  } /* of 'switch' */
  if ((pft->stand->cell->coord.lat>=0.0 && day==NDAYYEAR) ||
      (pft->stand->cell->coord.lat<0.0 && day==COLDEST_DAY_SHEMISPHERE))
  {
    pft->aphen=pft->gdd=0.0;
    tree->isphen=FALSE;

  }
  if (pft->phen>0)
    pft->aphen++;

} /* of 'phenology_tree' */
