/***************************************************************************/
/**                                                                       **/
/**                    n  p  p  _  t  r  e  e  .  c                       **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-04-25 16:34:30 +0200 (Mon, 25 Apr 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"

Real npp_tree(Pft *pft, /* PFT variables */
              Real gtemp_air, /* value of air temperature response function */
              Real gtemp_soil, /* value of soil temperature response function */
              Real assim,  /* assimilation (gC/m2) */
              Bool with_nitrogen /* with nitrogen (TRUE/FALSE) */
             ) /* returns net primary productivity (gC/m2) */
{
  Pfttree *tree;
  const Pfttreepar *par;
  Real mresp,npp;
#ifdef NRESP
  Real cn_root,cn_sapwood; 
#endif
  tree=pft->data;
  par=pft->par->data;
#ifdef NRESP
  if(with_nitrogen && tree->ind.sapwood.carbon>epsilon)
    cn_sapwood=tree->ind.sapwood.nitrogen/tree->ind.sapwood.carbon;
  else 
    cn_sapwood=par->cn_ratio.sapwood;
  if(with_nitrogen && tree->ind.root.carbon>epsilon)
    cn_root=tree->ind.root.nitrogen/tree->ind.root.carbon;
  else 
    cn_root=par->cn_ratio.root;
  mresp=pft->nind*(tree->ind.sapwood.carbon*pft->par->respcoeff*param.k*cn_sapwood*gtemp_air+
                   tree->ind.root.carbon*pft->par->respcoeff*param.k*cn_root*gtemp_soil*pft->phen);
#else
  mresp=pft->nind*(tree->ind.sapwood.carbon*pft->par->respcoeff*param.k*par->cn_ratio.sapwood*gtemp_air+
                   tree->ind.root.carbon*pft->par->respcoeff*param.k*par->cn_ratio.root*gtemp_soil*pft->phen);
#endif
  npp=(assim<mresp) ? assim-mresp : (assim-mresp)*(1-param.r_growth);
  pft->bm_inc.carbon+=npp;
  return npp;
} /* of 'npp_tree' */
