/***************************************************************************/
/**                                                                       **/
/**               n  d  e  m  a  n  d  _  t  r  e  e  .  c                **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von BLoh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-01-27 16:01:42 +0100 (Fri, 27 Jan 201#$ **/
/**     By         : $Author:: cmueller                        $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"
#include "agriculture.h"

Real ndemand_tree(const Pft *pft,     /* pointer to PFT */
                  Real *ndemand_leaf, /* N demand of leaf (gN/m2) */
                  Real vmax,          /* vmax (gC/m2/day) */
                  Real daylength,     /* day length (h) */
                  Real temp,          /* temperature (deg C) */
                  int npft,           /* number of natural PFTs */
                  int nbiomass,       /* number of biomass types */
                  int ncft            /* number of crop PFTs */
                 )                    /* returns total N demand  (gN/m2) */
{
  Real nc_ratio;
  Irrigation *data;
  const Pfttree *tree;
  const Pfttreepar *treepar;
  Real ndemand_tot;
  tree=pft->data; 
  treepar=pft->par->data;
 *ndemand_leaf=((daylength==0) ?  0: param.p*0.02314815/daylength*vmax*exp(-param.k_temp*(temp-25))*f_lai(lai_tree(pft)))+param.n0*0.001*(pft->bm_inc.carbon*tree->falloc.leaf+tree->ind.leaf.carbon*pft->nind);
  nc_ratio=tree->ind.leaf.nitrogen/tree->ind.leaf.carbon;
  if(nc_ratio>pft->par->ncleaf.high)
    nc_ratio=pft->par->ncleaf.high;
  else if(nc_ratio<pft->par->ncleaf.low)
    nc_ratio=pft->par->ncleaf.low;
  ndemand_tot=*ndemand_leaf+tree->ind.root.nitrogen*pft->nind+tree->ind.sapwood.nitrogen*pft->nind+nc_ratio*(tree->excess_carbon*pft->nind+pft->bm_inc.carbon)*(tree->falloc.root/treepar->ratio.root+tree->falloc.sapwood/treepar->ratio.sapwood);
#ifdef DEBUG_N
  fprinttreephys2(stdout,tree->ind,pft->nind);
  printf("\n");
  printf("ndemand_to = %g vegn %g vegc %g ndemand_leaf %g nc_ratio %g %g \n",ndemand_tot,vegn_sum_tree(pft)-tree->ind.heartwood.nitrogen*pft->nind,vegc_sum_tree(pft),*ndemand_leaf,nc_ratio,*ndemand_leaf/(tree->ind.leaf.carbon*pft->nind+pft->bm_inc.carbon*tree->falloc.leaf));
#endif
  pft->stand->cell->balance.n_demand+=max(0,(ndemand_tot-(vegn_sum_tree(pft)-tree->ind.heartwood.nitrogen*pft->nind))*pft->fpc*pft->stand->frac);
  if(ndemand_tot>(vegn_sum_tree(pft)-tree->ind.heartwood.nitrogen*pft->nind))
  {
    if(pft->stand->type->landusetype==BIOMASS_TREE)
    {
      data=pft->stand->data;
      pft->stand->cell->output.pft_ndemand[(npft-nbiomass)+rbtree(ncft)+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)]+=ndemand_tot-(vegn_sum_tree(pft)-tree->ind.heartwood.nitrogen*pft->nind)-pft->bm_inc.nitrogen; /* stand->cell->ml.landfrac[data->irrigation].biomass_tree; */
    }
    else
      pft->stand->cell->output.pft_ndemand[pft->par->id]+=max(0,ndemand_tot-(vegn_sum_tree(pft)-tree->ind.heartwood.nitrogen*pft->nind));
  }
  return ndemand_tot;
} /* of 'ndemand_tree' */
