/***************************************************************************/
/**                                                                       **/
/**     m  i  x  _  v  e  g  _  t  r  e  e  .  c                          **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-04-25 16:34:30 +0200 (Mon, 25 Apr 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"

void mix_veg_tree(Pft *pft,Real scaler)
{
  Pfttree *tree;
  tree=pft->data;
  pft->nind*=scaler;
  pft->bm_inc.nitrogen*=scaler;
  pft->bm_inc.carbon*=scaler; /*not necessary as Carbon should always be zero when this function is called?*/
  tree->turn_litt.leaf.carbon*=scaler;
  tree->turn_litt.leaf.nitrogen*=scaler;
} /* of 'mix_veg_tree' */
