/***************************************************************************/
/**                                                                       **/
/**     l  i  t  t  e  r  _  u  p  d  a  t  e  _  t  r   e  e  .  c       **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-11-08 10:54:39 +0100 (Tue, 08 Nov 201#$ **/
/**     By         : $Author:: cmueller                        $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"

void litter_update_tree(Litter *litter, /* Litter pool */
                        Pft *pft,     /* PFT variables */
                        Real frac
                       )
{
  int i;
  const Pfttreepar *treepar;
  Pfttree *tree;
#ifdef DEBUG_N
  Stocks in,out;

  in = standstocks(pft->stand);
#endif
  tree=pft->data;
  treepar=pft->par->data;
#ifdef DEBUG_N
  printf("gturn %g %g\n",tree->turn_litt.leaf.nitrogen,tree->turn_litt.root.nitrogen);
#endif
  if(pft->nind>0)
    litter->ag[pft->litter].trait.leaf.nitrogen+=pft->bm_inc.nitrogen/pft->nind*frac;

  litter->ag[pft->litter].trait.leaf.carbon+=tree->ind.leaf.carbon*frac;
  litter->ag[pft->litter].trait.leaf.nitrogen+=tree->ind.leaf.nitrogen*frac;
  for(i=0;i<NFUELCLASS;i++)
  {
    litter->ag[pft->litter].trait.wood[i].carbon+=(tree->ind.sapwood.carbon+tree->ind.heartwood.carbon-
                                  tree->ind.debt.carbon+tree->excess_carbon)*frac*treepar->fuelfrac[i];
    litter->ag[pft->litter].trait.wood[i].nitrogen+=(tree->ind.sapwood.nitrogen+tree->ind.heartwood.nitrogen-
                                  tree->ind.debt.nitrogen)*frac*treepar->fuelfrac[i];
    update_fbd_tree(litter,pft->par->fuelbulkdensity,
                    (tree->ind.sapwood.carbon+tree->ind.heartwood.carbon-tree->ind.debt.carbon)
               *frac*treepar->fuelfrac[i],i);
  }
  litter->bg[pft->litter].carbon+=tree->ind.root.carbon*frac;
  litter->bg[pft->litter].nitrogen+=tree->ind.root.nitrogen*frac;
#ifdef DEBUG_N
  out = standstocks(pft->stand);
  printf("gturn2 %g %g\n",tree->turn_litt.leaf.nitrogen,tree->turn_litt.root.nitrogen);
  printf("tree litter uptdate in %g out %g\n",in.nitrogen,out.nitrogen);
#endif
} /* of 'litter_update_tree' */
