/***************************************************************************/
/**                                                                       **/
/**               i  s  n  e  g  _  t  r  e  e  .  c                      **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: 27.04.2004                                           **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"

Bool isneg_tree(const Pft *pft)
{
  Pfttree *tree;
  tree=pft->data;
#ifdef DEBUG3
  printf("isneg: %g %g %g %g %g %g %g %g\n",tree->ind.leaf.carbon*pft->nind,tree->ind.root.carbon*pft->nind,
         tree->ind.sapwood.carbon*pft->nind,tree->ind.heartwood.carbon*pft->nind,tree->ind.debt.carbon*pft->nind,pft->fpc,pft->nind,pft->bm_inc);
#endif
  return ((tree->ind.leaf.carbon+tree->ind.root.carbon+tree->ind.sapwood.carbon+tree->ind.heartwood.carbon-tree->ind.debt.carbon)<0.0 
         || tree->ind.root.carbon<0.0 || tree->ind.leaf.carbon<0.0 || tree->ind.sapwood.carbon<0.0 || tree->ind.heartwood.carbon<0.0
         ||pft->fpc<=1e-20 || pft->nind<=1e-20);
} /* of 'isneg_tree' */
