/***************************************************************************/
/**                                                                       **/
/**              f  r  e  e  _  t  r  e  e  .  c                          **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**     Function deallocates tree-specific variables                      **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2015-11-25 11:03:12 +0100 (Wed, 25 Nov 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"

void free_tree(Pft *pft)
{
  Pfttree *tree;
  tree=pft->data;
  pft->stand->soil.litter.ag[pft->litter].trait.leaf.carbon+=tree->turn.leaf.carbon*pft->nind-tree->turn_litt.leaf.carbon;
  pft->stand->soil.litter.ag[pft->litter].trait.leaf.nitrogen+=tree->turn.leaf.nitrogen*pft->nind-tree->turn_litt.leaf.nitrogen;
  update_fbd_tree(&pft->stand->soil.litter,pft->par->fuelbulkdensity,tree->turn.leaf.carbon*pft->nind-tree->turn_litt.leaf.carbon,0);
  pft->stand->soil.litter.bg[pft->litter].carbon+=tree->turn.root.carbon*pft->nind-tree->turn_litt.root.carbon;
  pft->stand->soil.litter.bg[pft->litter].nitrogen+=tree->turn.root.nitrogen*pft->nind-tree->turn_litt.root.nitrogen;
  free(pft->data);
} /* of 'free_tree' */
