/***************************************************************************/
/**                                                                       **/
/**                 f  p  r  i  n  t  _  t  r  e  e  .  c                 **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function prints tree-specific state variables in ASCII file       **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-11-30 12:18:24 +0100 (Wed, 30 Nov 201#$ **/
/**     By         : $Author:: cmueller                        $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"

void fprint_tree(FILE *file,const Pft *pft)
{
  Pfttree *tree;
  tree=pft->data;
  fprintf(file,"Height:\t\t%g (m)\n"
               "Crown area:\t%g (m2)\n"
               "Bark thickness:\t%g (cm)\n"
               "Gddtw:\t\t%g\n",
               tree->height,tree->crownarea,tree->barkthickness,
               tree->gddtw);
  if(pft->par->phenology==RAINGREEN)
    fprintf(file,"Aphen raingreen:\t%g\n",tree->aphen_raingreen);
  fprintf(file,"Mass:\t\t");
  fprinttreephys2(file,tree->ind,pft->nind);
  fprintf(file,"\nExcess carbon:\t%g (gC/m2)\n",tree->excess_carbon*pft->nind);
  fprintf(file,"falloc:\t\t%g %g %g\n",tree->falloc.leaf,tree->falloc.root,tree->falloc.sapwood);
} /* of 'fprint_tree' */
