/***************************************************************************/
/**                                                                       **/
/**      e  s  t  a  b  l  i  s  h  m  e  n  t  _  t  r  e  e  .  c       **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-11-09 09:01:04 +0100 (Wed, 09 Nov 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"

Stocks establishment_tree(Pft *pft,Real UNUSED(fpc_total),
                          Real fpc_type,int n_est)
{

  Real nind_old;
  Stocks acflux_est={0,0};
  Real est_pft;
  /* establishment rate for a particular PFT on modelled area
   * basis (for trees, indiv/m2; for grasses, fraction of
   * modelled area colonised establishment rate for a particular
   * PFT on modelled area basis (for trees, indiv/m2; for
   * grasses, fraction of modelled area colonised)
   */
  Real est_nind=0;
  Pfttree *tree;
  Pfttreepar *treepar;
  tree=pft->data;
  treepar=getpftpar(pft,data);
  if (fpc_type>=FPC_TREE_MAX || n_est<=epsilon)
  {
    allometry_tree(pft);
    return acflux_est;
  }
  if (pft->par->cultivation_type== BIOMASS)
	  est_nind=treepar->k_est-pft->nind;
  else
	  est_nind=treepar->k_est;
  est_pft=est_nind*(1.0-exp(-5.0*(FPC_TREE_MAX-fpc_type)))*(FPC_TREE_MAX-fpc_type)/(Real)n_est;
#ifdef SAFE
  if (est_pft<0.0)
  {
    fail(NEGATIVE_ESTABLISHMENT_ERR,TRUE,
         "establishment_area: negative establishment rate=%g, fpc_type=%g",est_pft,fpc_type);
  }
#endif

  nind_old=pft->nind;
  if (pft->nind<epsilon && vegc_sum(pft)<2.0) /* avoid C-balance error by checking vegc */
    pft->nind=0.0;
  pft->nind+=est_pft;
  /* Account for flux from the atmosphere to new saplings */
  acflux_est.carbon=phys_sum_tree(treepar->sapl)*est_pft;
  acflux_est.nitrogen=phys_sum_tree_n(treepar->sapl)*est_pft;

  /* Adjust average individual C biomass based on average biomass and density of the new saplings*/
  tree->ind.leaf.carbon=(tree->ind.leaf.carbon*nind_old+treepar->sapl.leaf.carbon*est_pft)/pft->nind;
  tree->ind.root.carbon=(tree->ind.root.carbon*nind_old+treepar->sapl.root.carbon*est_pft)/pft->nind;
  tree->ind.sapwood.carbon=(tree->ind.sapwood.carbon*nind_old+treepar->sapl.sapwood.carbon*est_pft)/pft->nind;
  tree->ind.heartwood.carbon=(tree->ind.heartwood.carbon*nind_old+treepar->sapl.heartwood.carbon*est_pft)/pft->nind;
  tree->ind.debt.carbon=tree->ind.debt.carbon*nind_old/pft->nind;
  tree->excess_carbon*=nind_old/pft->nind;
  /* do the same for N */
  tree->ind.leaf.nitrogen=(tree->ind.leaf.nitrogen*nind_old+treepar->sapl.leaf.nitrogen*est_pft)/pft->nind;
  tree->ind.root.nitrogen=(tree->ind.root.nitrogen*nind_old+treepar->sapl.root.nitrogen*est_pft)/pft->nind;
  tree->ind.sapwood.nitrogen=(tree->ind.sapwood.nitrogen*nind_old+treepar->sapl.sapwood.nitrogen*est_pft)/pft->nind;
  tree->ind.heartwood.nitrogen=(tree->ind.heartwood.nitrogen*nind_old+treepar->sapl.heartwood.nitrogen*est_pft)/pft->nind;
  tree->ind.debt.nitrogen=tree->ind.debt.nitrogen*nind_old/pft->nind;

  //pft->bm_inc.nitrogen=(pft->bm_inc.nitrogen*nind_old+acflux_est.nitrogen)/pft->nind;

  /*if((pft->par->phenology==SUMMERGREEN || pft->par->phenology==RAINGREEN) && nind_old==0)
  {
    tree->turn.leaf.carbon+=treepar->sapl.leaf.carbon*treepar->turnover.leaf;
    tree->turn.leaf.nitrogen+=treepar->sapl.leaf.nitrogen*treepar->turnover.leaf;
    tree->turn_litt.leaf.carbon+=treepar->sapl.leaf.carbon*treepar->turnover.leaf*pft->nind;
    tree->turn_litt.leaf.nitrogen+=treepar->sapl.leaf.nitrogen*treepar->turnover.leaf*pft->nind;
    pft->stand->soil.litter.ag[pft->litter].trait.leaf.carbon+=treepar->sapl.leaf.carbon*treepar->turnover.leaf*pft->nind;
    pft->stand->soil.litter.ag[pft->litter].trait.leaf.nitrogen+=treepar->sapl.leaf.nitrogen*treepar->turnover.leaf*pft->nind;
    update_fbd_tree(&pft->stand->soil.litter,pft->par->fuelbulkdensity,(-treepar->sapl.leaf.carbon*treepar->turnover.leaf*pft->nind),0);
  }*/
  allometry_tree(pft);
  fpc_tree(pft);
  return acflux_est;
} /* of 'establishment_tree' */
