/***************************************************************************/
/**                                                                       **/
/**      c  o  p  p  i  c  e  _  t  r  e  e  .  c                         **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: 27.09.2004                                           **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"

#define HARVEST_EFFICIENCY 0.9
/* Sapwood reduction needs to be lower to avoid fatal numerical instabilities in allometry */
/* Makes sense as part (~30 %) of sapwood carbon is located underground */
#define HARVEST_EFFICIENCY_SAP 0.65


Stocks coppice_tree(Pft *pft)
{
  Pfttree *tree;
  const Pfttreepar *treepar;
  Stocks harvest={0,0};
  Stocks leaf_old;
  tree=pft->data;
  treepar=getpftpar(pft,data);

  harvest.carbon=(((tree->ind.sapwood.carbon*HARVEST_EFFICIENCY_SAP+tree->ind.heartwood.carbon*HARVEST_EFFICIENCY)-tree->ind.debt.carbon)*pft->nind);
  harvest.nitrogen=(((tree->ind.sapwood.nitrogen*HARVEST_EFFICIENCY_SAP+tree->ind.heartwood.nitrogen*HARVEST_EFFICIENCY)-tree->ind.debt.nitrogen)*pft->nind);
  leaf_old.carbon=tree->ind.leaf.carbon;
  leaf_old.nitrogen=tree->ind.leaf.nitrogen;
 /*printf("%d biomass harvest is %.2f, %.2f  tC/ha/yr or %.2f tDM/ha/yr\n",*/
/*  printf("coppice %d %.2f %.2f %.2f %.2f %.2f\n",
    year,harvest/100,harvest/100/treepar->rotation,harvest/100*2/treepar->rotation,
    (tree->ind.heartwood+tree->ind.sapwood+tree->ind.leaf+tree->ind.root)*pft->nind/100,
    (tree->ind.heartwood+(tree->ind.sapwood*0.7)+tree->ind.leaf)*pft->nind/100);*/
  tree->ind.heartwood.carbon*=1-HARVEST_EFFICIENCY;
  tree->ind.sapwood.carbon*=1-HARVEST_EFFICIENCY_SAP;
  tree->ind.debt.carbon=0;
  tree->ind.leaf.carbon=8000*tree->ind.sapwood.carbon/(wooddens*tree->height*pft->par->sla);
  harvest.carbon+=(leaf_old.carbon-tree->ind.leaf.carbon)*pft->nind;
  tree->ind.heartwood.nitrogen*=1-HARVEST_EFFICIENCY;
  tree->ind.sapwood.nitrogen*=1-HARVEST_EFFICIENCY_SAP;
  tree->ind.debt.nitrogen=0;
  tree->ind.leaf.nitrogen=8000*tree->ind.sapwood.nitrogen/(wooddens*tree->height*pft->par->sla);
  harvest.nitrogen+=(leaf_old.nitrogen-tree->ind.leaf.nitrogen)*pft->nind;
  /* Call allometry to adjust height and crownarea */
  allometry_tree(pft);
  fpc_tree(pft);

  return harvest;
} /* of 'coppice_tree' */

/* Simulate coppicing of SRWC tree
 * put all leafmass into litter
 * put 90 % of heart- and sapwood into harvest
 * fine roots remain unchanged
 * sapwood and heartwood are reduced by 90 % */
