/***************************************************************************/
/**                                                                       **/
/**              a  l  p  h  a  a  _  t  r  e  e  .  c                    **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran version         **/
/**                                                                       **/
/**     written by Christoph Mueller                                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-02-23 12:38:53 +0100 (Thu, 23 Feb 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "tree.h"

Real alphaa_tree(const Pft *pft,int UNUSED(lai_opt))
{
  Pfttree *tree;
  Real scaler=1.0;
  tree=pft->data;
  /* sink-limitation: downscale alphaa if there is too much carbon that cannot be allocated under
     given N limitation*/
  if((tree->ind.leaf.carbon+tree->excess_carbon*tree->falloc.leaf)>10){
    /*scaler=tree->ind.sapwood.nitrogen/(tree->ind.sapwood.carbon+tree->excess_carbon) /
           pft->par->ncleaf.low*treepar->ratio.sapwood;*/
    scaler=tree->ind.leaf.nitrogen/(tree->ind.leaf.carbon+tree->excess_carbon*tree->falloc.leaf) /
           pft->par->ncleaf.low;
    if(scaler>1) 
      scaler=1.0;
    else
      scaler=(1+param.par_sink_limit)*scaler/(scaler+param.par_sink_limit);
  }
  return pft->par->alphaa*scaler;
} /* of 'alphaa_tree' */
