/***************************************************************************/
/**                                                                       **/
/**                     r  e  a  d  r  e  a  l  v  e  c  .  c             **/
/**                                                                       **/
/**     Function reads real array from binary file converting from given  **/
/**     data type.                                                        **/
/**                                                                       **/
/**     written by Werner von Bloh                                        **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2018-05-16 15:15:17 +0200 (Wed, 16 May 201#$ **/
/**     By         : $Author:: herzfeld                        $          **/
/**                                                                       **/
/***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "types.h"
#include "swap.h"

Bool readrealvec(FILE *file,Real data[],Real intercept,Real slope,size_t n,
                 Bool swap,Type type)
{
  int *ivec;
  float *fvec;
  short *svec;
  Byte *bvec;
  double *dvec;
  size_t i;
  switch(type)
  {
    case LPJ_BYTE:
      bvec=newvec(Byte,n);
      if(bvec==NULL)
        return TRUE;
      if(fread(bvec,1,n,file)!=n)
      {
        free(bvec);
        return TRUE;
      }
      for(i=0;i<n;i++)
        data[i]=intercept+bvec[i]*slope; 
      free(bvec);
      break;
    case LPJ_SHORT:
      svec=newvec(short,n);
      if(svec==NULL)
        return TRUE;
      if(freadshort(svec,n,swap,file)!=n)
      {
        free(svec);
        return TRUE;
      }
      for(i=0;i<n;i++)
        data[i]=intercept+svec[i]*slope; 
      free(svec);
      break;
    case LPJ_INT:
      ivec=newvec(int,n);
      if(ivec==NULL)
        return TRUE;
      if(freadint(ivec,n,swap,file)!=n)
      {
        free(ivec);
        return TRUE;
      }
      for(i=0;i<n;i++)
        data[i]=intercept+ivec[i]*slope; 
      free(ivec);
      break;
    case LPJ_FLOAT:
      fvec=newvec(float,n);
      if(fvec==NULL)
        return TRUE;
      if(freadfloat(fvec,n,swap,file)!=n)
      {
        free(fvec);
        return TRUE;
      }
      for(i=0;i<n;i++)
        data[i]=intercept+fvec[i]*slope; 
      free(fvec);
      break;
    case LPJ_DOUBLE:
      dvec=newvec(double,n);
      if(dvec==NULL)
        return TRUE;
      if(freaddouble(dvec,n,swap,file)!=n)
      {
        free(dvec);
        return TRUE;
      }
      for(i=0;i<n;i++)
        data[i]=intercept+dvec[i]*slope; 
      free(dvec);
      break;
  } /* of switch */
  return FALSE;
} /* of 'readrealvec' */
