/*************************************************************************************/
/**                                                                                 **/
/**     u  p  d  a  t  e  l  i  t  t  e  r  p  r  o  p  e  r  t  i  e  s  .  c      **/
/**                                                                                 **/
/**          C implementation of LPJ, derived from the Fortran/C++ version          **/
/**                                                                                 **/
/**          Function computes total carbon  of all litter pools                    **/
/**                                                                                 **/
/**          written by Werner von Bloh, Sibyll Schaphoff                           **/
/**          Potsdam Institute for Climate Impact Research                          **/
/**          PO Box 60 12 03                                                        **/
/**          14412 Potsdam/Germany                                                  **/
/**                                                                                 **/
/**          Last change: $Date:: 2017-09-04 18:28:02 +0200 (Mon, 04 Sep 201#$      **/
/**          By         : $Author:: heinke                          $               **/
/**                                                                                 **/
/*************************************************************************************/

#include "lpj.h"

void updatelitterproperties(Stand *stand)       /* Stand pointer */
{
  int l;
  Real dm_sum=0;
  for(l=0;l<stand->soil.litter.n;l++)
//printf("soillitter amount of pools %d\n",stand->soil.litter.n);
//printf("soillitter pftlist[%d] is %g \n",l,stand->soil.litter.ag[l].trait.leaf.carbon,stand->soil.litter.ag[l].trait.leaf.carbon); 
   dm_sum+=stand->soil.litter.ag[l].trait.leaf.carbon/0.42;
  if(dm_sum<0)
    dm_sum=0;
#ifdef ADJUSTED
 stand->soil.litter.agtop_cover=1-exp(-4e-3*dm_sum);
// printf("residue cover parameter is adjusted\n");
#else
  stand->soil.litter.agtop_cover=1-exp(-6e-3*dm_sum);
#endif
//printf("dm_sum %g and agtop_cover %g\n",dm_sum,stand->soil.litter.agtop_cover);
  stand->soil.litter.agtop_wcap=2e-3*dm_sum;
//printf("wcap is %g dm_sum is %g  cover is %g moisture is %g \n",stand->soil.litter.agtop_wcap,dm_sum,stand->soil.litter.agtop_cover,stand->soil.litter.agtop_moist);
  if((stand->soil.litter.agtop_moist-stand->soil.litter.agtop_wcap)>epsilon)
  {
    stand->cell->balance.totw-=(stand->soil.litter.agtop_moist-stand->soil.litter.agtop_wcap)*stand->frac;
    stand->cell->balance.soil_storage-=(stand->soil.litter.agtop_moist-stand->soil.litter.agtop_wcap)*stand->frac*stand->cell->coord.area;
    stand->soil.litter.agtop_moist=stand->soil.litter.agtop_wcap;
//printf("if statement is true, litter moist is %g \n", stand->soil.litter.agtop_moist);  
}
} /* of 'updatelitterproperties' */
