/***************************************************************************/
/**                                                                       **/
/**                t  i  l  l  a  g  e  .  c                              **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function copies soil variables                                    **/
/**                                                                       **/
/**     written by                       **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-07-05 16:37:12 +0200 (Wed, 05 Jul 201#$ **/
/**     By         : $Author:: lutz                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void tillage(Stand *stand, Real frac)
{
  int i,l,day;

  /* move above ground litter pools to same litter structure in sub-soil (agsub) */
  for (l = 0; l < stand->soil.litter.n; l++)
  {
    stand->soil.litter.agsub[l].trait.leaf.carbon += stand->soil.litter.ag[l].trait.leaf.carbon*frac;
	  stand->soil.litter.ag[l].trait.leaf.carbon *= (1-frac);
    if (stand->soil.litter.ag[l].trait.leaf.carbon < epsilon) stand->soil.litter.ag[l].trait.leaf.carbon = 0;
    stand->soil.litter.agsub[l].trait.leaf.nitrogen += stand->soil.litter.ag[l].trait.leaf.nitrogen*frac;
    stand->soil.litter.ag[l].trait.leaf.nitrogen *= (1 - frac);
    if (stand->soil.litter.ag[l].trait.leaf.nitrogen < epsilon) stand->soil.litter.ag[l].trait.leaf.nitrogen = 0;

    for (i = 0; i < NFUELCLASS; i++)
    {
		stand->soil.litter.agsub[l].trait.wood[i].carbon += stand->soil.litter.ag[l].trait.wood[i].carbon*frac;
		stand->soil.litter.ag[l].trait.wood[i].carbon *= (1 - frac);
    if (stand->soil.litter.ag[l].trait.wood[i].carbon < epsilon) stand->soil.litter.ag[l].trait.wood[i].carbon = 0;
	  stand->soil.litter.agsub[l].trait.wood[i].nitrogen += stand->soil.litter.ag[l].trait.wood[i].nitrogen*frac;
	  stand->soil.litter.ag[l].trait.wood[i].nitrogen *= (1 - frac);
    if (stand->soil.litter.ag[l].trait.wood[i].nitrogen < epsilon) stand->soil.litter.ag[l].trait.wood[i].nitrogen = 0;
    }
  }

  /* do some changes to bulk density here */
  for(l=0;l<NTILLLAYER;l++)
    stand->soil.df_tillage[l]-=(stand->soil.df_tillage[l]-0.667*1)*param.mixing_efficiency; /* eq. 305 from APEX documentation, expressed as fraction of BD after full settling */

  /* do whatever tillage is supposed to do otherwise here */
   
}
