/***************************************************************************/
/**                                                                       **/
/**                s  o  i  l  s  t  o  c  k  s  .  c                     **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function computes total carbon/nitrogen in soil                   **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2014-07-28 15:56:03 +0200 (Mon, 28 Jul 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

Stocks soilstocks(const Soil *soil)
{
  Stocks stocks;
  int l;
  stocks=litterstocks(&soil->litter);
  forrootsoillayer(l)
  {
    stocks.carbon+=soil->pool[l].slow.carbon+soil->pool[l].fast.carbon;
    stocks.nitrogen+=soil->pool[l].slow.nitrogen+soil->pool[l].fast.nitrogen
                     +soil->NO3[l]+soil->NH4[l];
  }
  stocks.carbon+=soil->YEDOMA;
  return stocks;
} /* of 'soilstocks' */
