/***************************************************************************/
/**                                                                       **/
/**                s  o  i  l  c  a  r  b  o  n  .  c                     **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function computes total carbon in soil                            **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-03-09 11:38:42 +0100 (Wed, 09 Mar 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

Real soilcarbon(const Soil *soil)
{
  Real carbon=0;
  int l;
  forrootsoillayer(l)
    carbon+=soil->pool[l].slow.carbon+soil->pool[l].fast.carbon;
  carbon+=soil->YEDOMA;
  return carbon+littercarbon(&soil->litter);
} /* of 'soilcarbon' */

Real soilcarbon_slow(const Soil *soil)
{
  Real carbon=0;
  int l;
  forrootsoillayer(l)
     carbon+=soil->pool[l].slow.carbon;
  return carbon;
} /* of 'soilcarbon_slow' */
