
/***************************************************************************/
/**                                                                       **/
/**                s  e  t  s  o  i  l  c  a  r  b  o  n  .  c            **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function set new total nitrogen soil preservinf ratio between     **/
/**     different pools                                                   **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-03-09 11:38:42 +0100 (Wed, 09 Mar 201#$ **/
/**     By         : $Author:: lutz                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void setsoilnitrogen(Soil *soil, Real nitrogen_new, Real depth)
{
  int i, l,numLayers;
  Real nitrogen_old=0.0;
  /*define soil layer based on prescribed soil depth*/
  numLayers = 0;
  if (depth == 20) {
    numLayers = 1;
  }
  else if (depth == 100) {
    numLayers = 3;
  }
 // Real nh4_obs = 7.951517; /*observed values g/m2*/
 // Real no3_obs = 1.390049; /*observed values g/m2*/
 // Real nh4_old; /*for summing up inorganic N pool*/
 // Real no3_old; /*for summing up inorganic N pool*/

  /*nitrogen_old=slow n+fast n+agsub.leaf.n+agsub.wood.n*+bg.n/

  /*first sum up "old" nitrogen soil pools*/
  for (l = 0; l < numLayers; l++)
    {
    nitrogen_old+= soil->pool[l].slow.nitrogen + soil->pool[l].fast.nitrogen;
   // nh4_old += soil->NH4[l];
    //no3_old += soil->NO3[l];
  } 

    /*then add up slow+fast N with agsub and litter to nitrogen old*/
for (l = 0; l < numLayers; l++)
{
  nitrogen_old+= soil->litter.agsub[l].trait.leaf.nitrogen+soil->litter.bg[l].nitrogen;
  for (i = 0; i<NFUELCLASS; i++)
  nitrogen_old+= soil->litter.agsub[l].trait.wood[i].nitrogen;
  }
//printf("detail run: NH4[%d] %g NO3[%d] %g before \n", l, soil->NH4[l], l, soil->NO3[l]);
/*set new pools*/
  forrootsoillayer(l)
  {
    soil->pool[l].slow.nitrogen *= nitrogen_new / nitrogen_old;
    soil->pool[l].fast.nitrogen *= nitrogen_new / nitrogen_old;
   // soil->NH4[l]*= nh4_obs / nh4_old;
   // soil->NO3[l]*= no3_obs / no3_old;
  }
 // printf("detail run: NH4[%d] %g NO3[%d] %g after \n", l, soil->NH4[l], l, soil->NO3[l]);
 // printf("nh4 obs %g, nh4_old %g, no3_obs %g, no3_old %g\n", nh4_obs, nh4_old, no3_obs, no3_old);
  /*scale all layers and organic pools*/
  for (l = 0; l < soil->litter.n; l++)
  {
    soil->litter.agsub[l].trait.leaf.nitrogen *= nitrogen_new / nitrogen_old;
    for (i = 0; i<NFUELCLASS; i++)
      soil->litter.agsub[l].trait.wood[i].nitrogen *= nitrogen_new / nitrogen_old;
    soil->litter.bg[l].nitrogen *= nitrogen_new / nitrogen_old;
  }
  printf("detail run:nitrogen_new %g, nitrogen_old %g\n", nitrogen_new, nitrogen_old);
} /* of 'setsoilnitrogen' */

