
/***************************************************************************/
/**                                                                       **/
/**                s  e  t  s  o  i  l  c  a  r  b  o  n  .  c            **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function set new total carbon soil preservinf ratio between       **/
/**     different pools                                                   **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-03-09 11:38:42 +0100 (Wed, 09 Mar 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

Real littercarbon_var(const Litter *litter,
                      Real depth /* litter pools */
)                     /* returns total carbon (gC/m2) */
{
  int i, l, numLayers;
  Real sum;
  sum = 0;
  /*define soil layer based on prescribed soil depth*/
  numLayers = 0;
  if (depth == 20) {
    numLayers = 1;
  }
  else if (depth == 100) {
    numLayers = 3;
  }
   /*sum up carbon contained in litter: agsub and bg in predefined soil depth*/
  for (l = 0; l < numLayers; l++)
  {
    sum += litter->agsub[l].trait.leaf.carbon;
    sum += litter->bg[l].carbon;
    for (i = 0; i < NFUELCLASS; i++)
    {
      sum += litter->agsub[l].trait.wood[i].carbon;
    }
  }
    return sum;
  }
 /* of 'littercarbon' */

Real soilcarbon_var(const Soil *soil,
  Real depth)
{
  
  Real carbon = 0;
  int l,numLayers;
  /*define soil layer based on prescribed soil depth*/
  numLayers = 0;
  if (depth == 20) {
    numLayers = 1;
  }
  else if (depth == 100) {
    numLayers = 3;
  }
  /*sum up carbon slow and fast in the predefined soil layers*/
  for (l = 0; l < numLayers; l++)
  {
    carbon += soil->pool[l].slow.carbon + soil->pool[l].fast.carbon;
  }
        carbon += soil->YEDOMA;
     
    return carbon + littercarbon_var(&soil->litter, depth);
  } /* of 'soilcarbon' */




void  setsoilcarbon(Soil *soil, Real carbon_new, Real depth)
{
  int i, l;
  Real carbon_old;
  
  /*carbon_old=slow c+fast c+agsub.leaf.c+agsub.wood.c+bg.c*/
  carbon_old = soilcarbon_var(soil,depth); /*carbon lpj for certain depth*/
  /*scaling*/
  forrootsoillayer(l)
  {
    soil->pool[l].slow.carbon *= carbon_new / carbon_old; /*carbon new of specific depth/ carbon old of specific depth*/
    soil->pool[l].fast.carbon *= carbon_new / carbon_old; /*carbon new of specific depth/ carbon old of specific depth*/
  }
  soil->YEDOMA *= carbon_new / carbon_old;
  /*scale all layers and organic pools*/
  for (l = 0; l < soil->litter.n; l++)
  {
    soil->litter.agsub[l].trait.leaf.carbon *= carbon_new / carbon_old;
    for (i = 0; i<NFUELCLASS; i++)
    soil->litter.agsub[l].trait.wood[i].carbon *= carbon_new / carbon_old;
    soil->litter.bg[l].carbon *= carbon_new / carbon_old;
  }
 printf("using observed valued; carbon_new %g, carbon_old %g\n", carbon_new, carbon_old);
} /* of 'setsoilcarbon' */
