/***************************************************************************/
/**                                                                       **/
/**         n  u  p  t  a  k  e  _  t  e  m  p  _  f  c  n  .  c          **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function calculates temperature limitation in N uptake of roots   **/
/**     after Thornley (1991)                                             **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2018-05-16 15:15:17 +0200 (Wed, 16 May 201#$ **/
/**     By         : $Author:: herzfeld                        $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

#define T_m 15.0
#define T_0 (-25.0)
#define T_r 15.0

Real nuptake_temp_fcn(Real soiltemp)
{
 return max((soiltemp-T_0)*(2*T_m-T_0-soiltemp)/(T_r-T_0)/(2*T_m-T_0-T_r),0);
} /* of 'nuptake_temp_fcn' */
