/***************************************************************************/
/**                                                                       **/
/**                n  e  w  _  s  o  i  l  .  c                           **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: 23.01.2009                                           **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void newsoil(Soil *soil)
{
  int l;
  soil->litter.n=0;
  soil->litter.ag=NULL;
  soil->litter.agsub=NULL;
  soil->litter.bg=NULL;
  soil->litter.agtop_wcap=soil->litter.agtop_moist=soil->litter.agtop_cover=soil->litter.agtop_temp=0;
  forrootsoillayer(l)
    soil->pool[l].fast.carbon=soil->pool[l].slow.carbon=soil->pool[l].fast.nitrogen=soil->pool[l].slow.nitrogen=soil->YEDOMA=0.0;
} /* of 'newsoil' */
