/***************************************************************************/
/**                                                                       **/
/**                l  i  t  t  e  r  s  t  o  c  k  s  .  c               **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function computes sum of all litter pools                         **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-09-04 18:28:02 +0200 (Mon, 04 Sep 201#$ **/
/**     By         : $Author:: heinke                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

Stocks litterstocks(const Litter *litter)
{
  int i,l;
  Stocks sum={0,0};
  for(l=0;l<litter->n;l++)
  {
    sum.carbon += litter->ag[l].trait.leaf.carbon;
    sum.nitrogen += litter->ag[l].trait.leaf.nitrogen;
    sum.carbon += litter->agsub[l].trait.leaf.carbon;
    sum.nitrogen += litter->agsub[l].trait.leaf.nitrogen;
    for(i=0;i<NFUELCLASS;i++)
    {
      sum.carbon += litter->ag[l].trait.wood[i].carbon;
      sum.nitrogen += litter->ag[l].trait.wood[i].nitrogen;
      sum.carbon += litter->agsub[l].trait.wood[i].carbon;
      sum.nitrogen += litter->agsub[l].trait.wood[i].nitrogen;
    }
    sum.carbon+=litter->bg[l].carbon;
    sum.nitrogen+=litter->bg[l].nitrogen;
  }
  return sum;
} /* of 'litterstocks' */
