/***************************************************************************/
/**                                                                       **/
/**                l  i  t  t  e  r  c  a  r  b  o  n  .  c               **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function computes total carbon  of all litter pools               **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-09-08 17:15:54 +0200 (Fri, 08 Sep 201#$ **/
/**     By         : $Author:: heinke                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

Real littercarbon(const Litter *litter /* litter pools */
                 )                     /* returns total carbon (gC/m2) */
{
  int i,l;
  Real sum;
  sum=0;
  for (l = 0; l < litter->n; l++)
  {
    sum+=litter->ag[l].trait.leaf.carbon+litter->agsub[l].trait.leaf.carbon;
    for(i=0;i<NFUELCLASS;i++)
      sum+=litter->ag[l].trait.wood[i].carbon+litter->agsub[l].trait.wood[i].carbon;
    sum+=litter->bg[l].carbon;
  }
  return sum;
} /* of 'littercarbon' */
