/***************************************************************************/
/**                                                                       **/
/**                g  e  t  r  o  o  t  d  i  s  t  .  c                  **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Ursula Heyder,Sibyll Schaphoff                         **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2018-05-16 15:15:17 +0200 (Wed, 16 May 201#$ **/
/**     By         : $Author:: herzfeld                        $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void getrootdist(Real rootdist_n[],const Real rootdist[],Real mean_maxthaw)
{
  Real root_u,freeze_depth,layer,root_nu,thaw_depth;
  int i,l;
  root_u=layer=0;
  forrootsoillayer(l)
    rootdist_n[l]=rootdist[l];
  /*adjust root layer*/
  if(layerbound[BOTTOMLAYER]>mean_maxthaw &&
                mean_maxthaw>epsilon)
  {
    forrootsoillayer(l)
    {
      layer+=soildepth[l];
      root_u+=rootdist[l];
      freeze_depth=layer-mean_maxthaw;
      if (freeze_depth>0)
      {
        thaw_depth=soildepth[l]-freeze_depth;
        rootdist_n[l]=thaw_depth/soildepth[l]*rootdist[l];
        root_nu=rootdist[l]-rootdist_n[l];
        root_u-= root_nu;
        l++;
        break;
      }
    }
    for(i=l;i<BOTTOMLAYER;i++)
      rootdist_n[i]=0;
    /* rescale sum of rootdist_n to one */
    for(i=l-1;i>=0;--i)
      rootdist_n[i]/=root_u;
  }
} /* of 'getrootdist' */
