/***************************************************************************/
/**                                                                       **/
/**               f  w  r  i  t  e  s  o  i  l  .  c                      **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function write soil variables into binary file                    **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-11-06 23:06:03 +0100 (Mon, 06 Nov 201#$ **/
/**     By         : $Author:: heinke                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

Bool fwritesoil(FILE *file,const Soil *soil,int ntotpft)
{
  int l;
  forrootsoillayer(l)
  {
    fwrite1(&soil->pool[l],sizeof(Pool),file);
    fwriten(soil->c_shift_fast[l],sizeof(Real),ntotpft,file);
    fwriten(soil->c_shift_slow[l],sizeof(Real),ntotpft,file);
  }
  if(fwritelitter(file,&soil->litter))
    return TRUE;
  fwriten(soil->NO3,sizeof(Real),LASTLAYER,file);
  fwriten(soil->NH4,sizeof(Real),LASTLAYER,file);
  fwriten(soil->wsat, sizeof(Real), NSOILLAYER, file);
  fwriten(soil->wpwp, sizeof(Real), NSOILLAYER, file);
  fwriten(soil->wfc, sizeof(Real), NSOILLAYER, file);
  fwriten(soil->whc, sizeof(Real), NSOILLAYER, file);
  fwriten(soil->whcs, sizeof(Real), NSOILLAYER, file);
  fwriten(soil->wpwps, sizeof(Real), NSOILLAYER, file);
  fwriten(soil->wsats, sizeof(Real), NSOILLAYER, file);
  fwriten(soil->beta_soil, sizeof(Real), NSOILLAYER, file);
  fwriten(soil->bulkdens, sizeof(Real), NSOILLAYER, file);
  fwriten(soil->k_dry, sizeof(Real), NSOILLAYER, file);
  fwriten(soil->Ks, sizeof(Real), NSOILLAYER, file);
  fwriten(soil->df_tillage, sizeof(Real), NTILLLAYER, file);
  fwriten(soil->w,sizeof(Real),NSOILLAYER,file);
  fwrite1(&soil->w_evap,sizeof(Real),file);
  fwriten(soil->w_fw,sizeof(Real),NSOILLAYER,file);
  fwrite1(&soil->snowpack,sizeof(Real),file);
  fwriten(soil->temp,sizeof(Real),NSOILLAYER+1,file);
  fwriten(soil->ice_depth,sizeof(Real),NSOILLAYER,file);
  fwriten(soil->ice_fw,sizeof(Real),NSOILLAYER,file);
  fwriten(soil->freeze_depth,sizeof(Real),NSOILLAYER,file);
  fwriten(soil->ice_pwp,sizeof(Real),NSOILLAYER,file);
  fwriten(soil->perc_energy,sizeof(Real),NSOILLAYER,file);
  fwriten(soil->state,sizeof(short),NSOILLAYER,file);
  fwrite1(&soil->mean_maxthaw,sizeof(Real),file);
  fwrite1(&soil->alag,sizeof(Real),file);
  fwrite1(&soil->amp,sizeof(Real),file);
  fwrite1(&soil->meanw1,sizeof(Real),file);
  return FALSE;
} /* of 'fwritesoil' */
