/***************************************************************************/
/**                                                                       **/
/**               f  w  r  i  t  e  l  i  t  t  e  r  .  c                **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function writes litter variables into binary file                 **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-10-12 11:57:29 +0200 (Thu, 12 Oct 201#$ **/
/**     By         : $Author:: heinke                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

Bool fwritelitter(FILE *file,const Litter *litter)
{
  Byte b;
  int l;
  fwrite(litter->avg_fbd,sizeof(Real),NFUELCLASS+1,file);
  b = (Byte)litter->n;
  fwrite1(&b, sizeof(b), file);
  for(l=0;l<litter->n;l++)
  {
    b=(Byte)litter->ag[l].pft->id;
    fwrite1(&b,sizeof(b),file);
    fwrite1(&litter->ag[l].trait,sizeof(Trait),file);
    fwrite1(&litter->agsub[l].trait,sizeof(Trait),file);
    fwrite1(&litter->bg[l],sizeof(Stocks),file);
  }
  fwrite1(&litter->agtop_wcap,sizeof(Real),file);
  fwrite1(&litter->agtop_moist,sizeof(Real),file);
  fwrite1(&litter->agtop_cover,sizeof(Real),file);
  fwrite1(&litter->agtop_temp,sizeof(Real),file);
  return FALSE;
} /* of 'fwritelitter' */
