/***************************************************************************/
/**                                                                       **/
/**              f  r  e  a  d  l  i  t  t  e  r  .  c                    **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function reads litter data from file                              **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-10-12 11:57:29 +0200 (Thu, 12 Oct 201#$ **/
/**     By         : $Author:: heinke                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

Bool freadlitter(FILE *file, /* File pointer to binary file */
                 Litter *litter, /* Litter pool to be read */
                 const Pftpar pftpar[], /* PFT parameter array */
                 int ntotpft, /* total number of PFTs */
                 Bool swap /* Byte order has to be changed (TRUE/FALSE) */
              )            /* returns TRUE on error */
{
  Byte b;
  int i;
  freadreal(litter->avg_fbd,NFUELCLASS+1,swap,file);
  if(fread(&b,sizeof(b),1,file)!=1)
    return TRUE;
  litter->n=b;
  if(litter->n)
  {
    litter->ag=newvec(Litteritem,litter->n);
    litter->agsub = newvec(Litteritem, litter->n);
    litter->bg=newvec(Stocks,litter->n);
    if(litter->ag==NULL || litter->agsub==NULL || litter->bg==NULL)
      return TRUE;
    for(i=0;i<litter->n;i++)
    {
      if(fread(&b,sizeof(b),1,file)!=1)
      {
        free(litter->ag);
        free(litter->agsub);
        free(litter->bg);
        litter->n=0;
        litter->ag=NULL;
        litter->agsub=NULL;
        litter->bg=NULL;
        return TRUE;
      }
      if(b>=ntotpft)
      {
        fprintf(stderr,"ERROR195: Invalid value %d for PFT index litter.\n",(int)b);
        free(litter->ag);
        free(litter->agsub);
        free(litter->bg);
        litter->n=0;
        litter->ag=NULL;
        litter->agsub=NULL;
        litter->bg=NULL;
        return TRUE;
      }
      litter->ag[i].pft=litter->agsub[i].pft=pftpar+b;
      if(freadreal((Real *)&litter->ag[i].trait,sizeof(Trait)/sizeof(Real),
                   swap,file)!=sizeof(Trait)/sizeof(Real))
        return TRUE;
      if(freadreal((Real *)&litter->agsub[i].trait,sizeof(Trait)/sizeof(Real),
                         swap,file)!=sizeof(Trait)/sizeof(Real))
        return TRUE;
      freadreal((Real *)(&litter->bg[i]),sizeof(Stocks)/sizeof(Real),swap,file);
    }
  }
  else
  {
    litter->ag=NULL;
    litter->agsub=NULL;
    litter->bg=NULL;
  }
  freadreal1(&litter->agtop_wcap,swap,file);
  freadreal1(&litter->agtop_moist,swap,file);
  freadreal1(&litter->agtop_cover,swap,file);
  freadreal1(&litter->agtop_temp,swap,file);
  return FALSE;
} /* of 'freadlitter' */
