/***************************************************************************/
/**                                                                       **/
/**                c  o  p  y  s  o  i  l  .  c                           **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function copies soil variables                                    **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-11-06 23:06:03 +0100 (Mon, 06 Nov 201#$ **/
/**     By         : $Author:: heinke                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void copysoil(Soil *dst,const Soil *src, int ntotpft)
{
  int i,l,p;
  dst->par=src->par;
  forrootsoillayer(l)
  {
    dst->pool[l]=src->pool[l];
    dst->k_mean[l]=src->k_mean[l];
    dst->NH4[l]=src->NH4[l];
    dst->NO3[l]=src->NO3[l];
/*	dst->wpwp[l]=src->wpwp[l];  
	dst->wfc[l]=src->wfc[l];
	dst->wsat[l]=src->wsat[l];
	dst->whc[l]=src->whc[l];
	dst->wsats[l]=src->wsats[l];
	dst->whcs[l]=src->whcs[l];
	dst->wpwps[l]=src->wpwps[l];
	dst->k_dry[l]=src->k_dry[l];
	dst->bulkdens[l]=src->bulkdens[l];
	dst->beta_soil[l]=src->beta_soil[l];
*/
    for(p=0;p<ntotpft;p++)
    {
      dst->c_shift_fast[l][p]=src->c_shift_fast[l][p];
      dst->c_shift_slow[l][p]=src->c_shift_slow[l][p];
    }
  }
  dst->YEDOMA=src->YEDOMA;
  dst->litter.decomC=src->litter.decomC;
  dst->alag=src->alag;
  dst->amp=src->amp;
  dst->meanw1=src->meanw1;
  dst->snowpack=src->snowpack;
  dst->maxthaw_depth=src->maxthaw_depth;
  dst->mean_maxthaw=src->mean_maxthaw;
  dst->drainage_class=src->drainage_class;
  dst->decomp_litter_mean.carbon=src->decomp_litter_mean.carbon;
  dst->decomp_litter_mean.nitrogen=src->decomp_litter_mean.nitrogen;
  freelitter(&dst->litter);
  dst->litter.n=src->litter.n;
  dst->whcs_all=src->whcs_all;
  dst->litter.agtop_wcap=src->litter.agtop_wcap;
  dst->litter.agtop_moist=src->litter.agtop_moist;
  dst->litter.agtop_cover=src->litter.agtop_cover;
  dst->litter.agtop_temp=src->litter.agtop_temp;
  if(src->litter.n>0)
  {
    dst->litter.ag=newvec(Litteritem,src->litter.n);
    check(dst->litter.ag);
    dst->litter.agsub = newvec(Litteritem, src->litter.n);
    check(dst->litter.agsub);
    dst->litter.bg=newvec(Stocks,src->litter.n);
    check(dst->litter.bg);
    for(i=0;i<src->litter.n;i++)
    {
      dst->litter.ag[i]=src->litter.ag[i];
      dst->litter.agsub[i] = src->litter.agsub[i];
      dst->litter.bg[i]=src->litter.bg[i];
    }
  }
  for(i=0;i<NFUELCLASS+1;i++)
    dst->litter.avg_fbd[i]=src->litter.avg_fbd[i];
  for(i=0;i<NSOILLAYER;i++)
  {
    dst->w[i]=src->w[i];
    dst->w_fw[i]=src->w_fw[i];
    dst->ice_fw[i]=src->ice_fw[i];
    dst->ice_depth[i]=src->ice_depth[i];
    dst->freeze_depth[i]=src->freeze_depth[i];
    dst->ice_pwp[i]=src->ice_pwp[i];
    dst->state[i]=src->state[i];
    dst->layer_exists[i]=src->layer_exists[i];
    dst->perc_energy[i]=src->perc_energy[i];
    dst->micro_heating[i]=src->micro_heating[i];
    dst->decomC[i]=src->decomC[i];
    dst->wpwp[i]=src->wpwp[i];  
    dst->wfc[i]=src->wfc[i];
    dst->wsat[i]=src->wsat[i];
    dst->whc[i]=src->whc[i];
    dst->wsats[i]=src->wsats[i];
    dst->whcs[i]=src->whcs[i];
    dst->wpwps[i]=src->wpwps[i];
    dst->k_dry[i]=src->k_dry[i];
    dst->Ks[i]=src->Ks[i];
    dst->bulkdens[i]=src->bulkdens[i];
    dst->beta_soil[i]=src->beta_soil[i];
}
  dst->w_evap=src->w_evap;
  for(i=0;i<NSOILLAYER+1;i++)
    dst->temp[i]=src->temp[i];
  dst->rw_buffer=src->rw_buffer;
  for(i=0;i<NTILLLAYER;i++)
     dst->df_tillage[i]=src->df_tillage[i];

} /* of 'copysoil' */
