/***************************************************************************/
/**                                                                       **/
/**                c  h  e  c  k  l  i  t  t  e  r  .  c                  **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2015-11-25 16:01:01 +0100 (Wed, 25 Nov 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

Stocks checklitter(Litter *litter)
{
  int i,l;
  Stocks sum={0,0};
  for(l=0;l<litter->n;l++)
  {
    if(litter->ag[l].trait.leaf.carbon<0)
    {
      sum.carbon+=litter->ag[l].trait.leaf.carbon;
      litter->ag[l].trait.leaf.carbon=0;
    }
    for(i=0;i<NFUELCLASS;i++)
      if(litter->ag[l].trait.wood[i].carbon<0)
      {
        sum.carbon+=litter->ag[l].trait.wood[i].carbon;
        litter->ag[l].trait.wood[i].carbon=0;
      }
    if(litter->bg[l].carbon<0)
    {
      sum.carbon+=litter->bg[l].carbon;
      litter->bg[l].carbon=0;
    }
    if(litter->ag[l].trait.leaf.nitrogen<0)
    {
      sum.nitrogen+=litter->ag[l].trait.leaf.nitrogen;
      litter->ag[l].trait.leaf.nitrogen=0;
    }
    for(i=0;i<NFUELCLASS;i++)
      if(litter->ag[l].trait.wood[i].nitrogen<0)
      {
        sum.nitrogen+=litter->ag[l].trait.wood[i].nitrogen;
        litter->ag[l].trait.wood[i].nitrogen=0;
      }
    if(litter->bg[l].nitrogen<0)
    {
      sum.nitrogen+=litter->bg[l].nitrogen;
      litter->bg[l].nitrogen=0;
    }
  }
  return sum;
} /* of 'checklitter' */
